/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.hlfernandez.visualization;

import es.uvigo.ei.sing.hlfernandez.dialog.FontConfigurationDialog;
import es.uvigo.ei.sing.hlfernandez.dialog.ListSelectionDialog;
import es.uvigo.ei.sing.hlfernandez.input.DoubleRange;
import es.uvigo.ei.sing.hlfernandez.input.DoubleRangeInputDialog;
import es.uvigo.ei.sing.hlfernandez.menu.HamburgerMenu;
import es.uvigo.ei.sing.hlfernandez.ui.icons.Icons;
import es.uvigo.ei.sing.hlfernandez.utilities.ExtendedAbstractAction;
import es.uvigo.ei.sing.hlfernandez.visualization.JHeatMap;
import es.uvigo.ei.sing.hlfernandez.visualization.JHeatMapDataOperationsDialog;
import es.uvigo.ei.sing.hlfernandez.visualization.JHeatMapOperations;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JHeatMapPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JHeatMap heatmap;
    private Optional<Font> heatmapFont = Optional.empty();

    public JHeatMapPanel(JHeatMap heatmap) {
        super(new BorderLayout());
        this.heatmap = heatmap;
        this.initComponent();
    }

    private void initComponent() {
        JPanel toolbar = new JPanel();
        toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        BoxLayout layout = new BoxLayout(toolbar, 0);
        toolbar.setLayout(layout);
        toolbar.add(this.getMenu());
        JComboBox<ComboColor> lowColorCB = new JComboBox<ComboColor>(ComboColor.values());
        this.fixComboSize(lowColorCB);
        lowColorCB.setSelectedItem((Object)ComboColor.GREEN);
        lowColorCB.addItemListener(e -> this.heatmap.setLowColor(((ComboColor)((Object)((Object)lowColorCB.getSelectedItem()))).getColor()));
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(new JLabel("Low: "));
        toolbar.add(lowColorCB);
        JComboBox<ComboColor> highColorCB = new JComboBox<ComboColor>(ComboColor.values());
        this.fixComboSize(highColorCB);
        highColorCB.setSelectedItem((Object)ComboColor.RED);
        highColorCB.addItemListener(e -> this.heatmap.setHighColor(((ComboColor)((Object)((Object)highColorCB.getSelectedItem()))).getColor()));
        toolbar.add(Box.createHorizontalStrut(10));
        toolbar.add(new JLabel("High: "));
        toolbar.add(highColorCB);
        toolbar.add(Box.createHorizontalStrut(10));
        this.add((Component)toolbar, "North");
        this.add((Component)this.heatmap, "Center");
    }

    private Component getMenu() {
        HamburgerMenu menu = new HamburgerMenu(HamburgerMenu.Size.SIZE16);
        menu.add(new ExtendedAbstractAction("Set range", Icons.ICON_RANGE_16, this::setHeatmapRange));
        menu.add(new ExtendedAbstractAction("Transform data", Icons.ICON_EDIT_16, this::transformDataMatrix));
        menu.add(new ExtendedAbstractAction("Visible rows", Icons.ICON_ROW_16, this::editVisibleRows));
        menu.add(new ExtendedAbstractAction("Visible columns", Icons.ICON_COLUMN_16, this::editVisibleColumns));
        menu.add(new ExtendedAbstractAction("Configure font", Icons.ICON_FONT_16, this::configureFont));
        menu.add(new ExtendedAbstractAction("Export heatmap as image", Icons.ICON_IMAGE_16, this::exportAsImage));
        return menu;
    }

    protected void editVisibleRows() {
        List<String> visible = this.heatmap.getVisibleRowNames();
        List<String> notVisible = this.heatmap.getRowNames();
        notVisible.removeAll(visible);
        try {
            ListSelectionDialog<String> dialog = new ListSelectionDialog<String>(this.getDialogParent(), visible, notVisible, "Visible rows", "Not visible rows");
            dialog.setVisible(true);
            if (!dialog.isCanceled()) {
                this.heatmap.setVisibleRowNames(dialog.getSelectedItems());
            }
        }
        catch (InvalidClassException e) {
            throw new RuntimeException(e);
        }
    }

    private Window getDialogParent() {
        return SwingUtilities.getWindowAncestor(this);
    }

    protected void editVisibleColumns() {
        List<String> visible = this.heatmap.getVisibleColumnNames();
        List<String> notVisible = this.heatmap.getColumnNames();
        notVisible.removeAll(visible);
        try {
            ListSelectionDialog<String> dialog = new ListSelectionDialog<String>(this.getDialogParent(), visible, notVisible, "Visible columns", "Not visible columns");
            dialog.setVisible(true);
            if (!dialog.isCanceled()) {
                this.heatmap.setVisibleColumnNames(dialog.getSelectedItems());
            }
        }
        catch (InvalidClassException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setHeatmapRange() {
        DoubleRangeInputDialog dialog = new DoubleRangeInputDialog(this.getDialogParent(), new DoubleRange(this.heatmap.getLowValue(), this.heatmap.getHighValue()));
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            this.heatmap.setValuesRange(dialog.getSelectedRange());
        }
    }

    protected void exportAsImage() {
        JFileChooser fc = new JFileChooser();
        int result = fc.showSaveDialog(this);
        if (result == 0) {
            try {
                this.heatmap.toPngImage(fc.getSelectedFile());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    protected void configureFont() {
        FontConfigurationDialog dialog = new FontConfigurationDialog(this.getDialogParent(), this.getHeatmapFont());
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            this.setHeatmapFont(dialog.getSelectedFont());
        }
    }

    private void setHeatmapFont(Font font) {
        this.heatmapFont = Optional.ofNullable(font);
        this.heatmap.setHeatmapFont(this.getHeatmapFont());
    }

    public Font getHeatmapFont() {
        return this.heatmapFont.orElse(this.getFont());
    }

    private void fixComboSize(JComboBox<ComboColor> lowColorCB) {
        Dimension d = new Dimension(120, 20);
        lowColorCB.setSize(d);
        lowColorCB.setMaximumSize(d);
        lowColorCB.setPreferredSize(d);
    }

    private void transformDataMatrix() {
        JHeatMapDataOperationsDialog dialog = new JHeatMapDataOperationsDialog(this.getDialogParent());
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            this.applyTransformations(dialog.getTransform(), dialog.getCentering());
        }
    }

    private void applyTransformations(JHeatMapOperations.Transform transform, JHeatMapOperations.Centering centering) {
        this.heatmap.setData(JHeatMapOperations.center(JHeatMapOperations.transform(this.heatmap.getData(), transform), centering, true));
    }

    private static enum ComboColor {
        RED(Color.RED, "Red"),
        GREEN(Color.GREEN, "Green"),
        BLUE(Color.BLUE, "Blue");

        private Color color;
        private String name;

        private ComboColor(Color color, String name) {
            this.color = color;
            this.name = name;
        }

        public Color getColor() {
            return this.color;
        }

        public String toString() {
            return this.name;
        }
    }
}

