/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.GraphicsState;
import com.itextpdf.text.pdf.parser.InlineImageInfo;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.PdfImageObject;
import com.itextpdf.text.pdf.parser.Vector;
import java.io.IOException;

public class ImageRenderInfo {
    private final GraphicsState gs;
    private final PdfIndirectReference ref;
    private final InlineImageInfo inlineImageInfo;
    private final PdfDictionary colorSpaceDictionary;
    private PdfImageObject imageObject = null;

    private ImageRenderInfo(GraphicsState gs, PdfIndirectReference ref, PdfDictionary colorSpaceDictionary) {
        this.gs = gs;
        this.ref = ref;
        this.inlineImageInfo = null;
        this.colorSpaceDictionary = colorSpaceDictionary;
    }

    private ImageRenderInfo(GraphicsState gs, InlineImageInfo inlineImageInfo, PdfDictionary colorSpaceDictionary) {
        this.gs = gs;
        this.ref = null;
        this.inlineImageInfo = inlineImageInfo;
        this.colorSpaceDictionary = colorSpaceDictionary;
    }

    public static ImageRenderInfo createForXObject(GraphicsState gs, PdfIndirectReference ref, PdfDictionary colorSpaceDictionary) {
        return new ImageRenderInfo(gs, ref, colorSpaceDictionary);
    }

    protected static ImageRenderInfo createForEmbeddedImage(GraphicsState gs, InlineImageInfo inlineImageInfo, PdfDictionary colorSpaceDictionary) {
        ImageRenderInfo renderInfo = new ImageRenderInfo(gs, inlineImageInfo, colorSpaceDictionary);
        return renderInfo;
    }

    public PdfImageObject getImage() throws IOException {
        this.prepareImageObject();
        return this.imageObject;
    }

    private void prepareImageObject() throws IOException {
        if (this.imageObject != null) {
            return;
        }
        if (this.ref != null) {
            PRStream stream = (PRStream)PdfReader.getPdfObject(this.ref);
            this.imageObject = new PdfImageObject(stream, this.colorSpaceDictionary);
        } else if (this.inlineImageInfo != null) {
            this.imageObject = new PdfImageObject(this.inlineImageInfo.getImageDictionary(), this.inlineImageInfo.getSamples(), this.colorSpaceDictionary);
        }
    }

    public Vector getStartPoint() {
        return new Vector(0.0f, 0.0f, 1.0f).cross(this.gs.ctm);
    }

    public Matrix getImageCTM() {
        return this.gs.ctm;
    }

    public float getArea() {
        return this.gs.ctm.getDeterminant();
    }

    public PdfIndirectReference getRef() {
        return this.ref;
    }

    public BaseColor getCurrentFillColor() {
        return this.gs.fillColor;
    }
}

