/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.operations;

import es.uvigo.ei.sing.s2p.core.entities.MascotEntry;
import es.uvigo.ei.sing.s2p.core.entities.MascotIdentifications;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class MascotIdentificationsOperations {
    public static MascotIdentifications filter(MascotIdentifications mascotIdentifications, int mascotScore) {
        return new MascotIdentifications(mascotIdentifications.stream().filter(e -> e.getMascotScore() >= mascotScore).collect(Collectors.toList()));
    }

    public static MascotIdentifications removeDuplicates(MascotIdentifications mascotIdentifications) {
        return new MascotIdentifications(mascotIdentifications.stream().distinct().collect(Collectors.toList()));
    }

    public static MascotIdentifications removeDuplicatedProteinNames(MascotIdentifications identifications) {
        Map<String, MascotIdentifications> proteinNamesToIdentifications = MascotIdentificationsOperations.getProteinNamesMap(identifications);
        proteinNamesToIdentifications.values().forEach(MascotIdentificationsOperations::sortByMascotScore);
        return new MascotIdentifications(proteinNamesToIdentifications.values().stream().map(m -> (MascotEntry)m.get(0)).collect(Collectors.toList()));
    }

    private static Map<String, MascotIdentifications> getProteinNamesMap(MascotIdentifications identifications) {
        HashMap<String, MascotIdentifications> proteinNamesToIdentifications = new HashMap<String, MascotIdentifications>();
        for (MascotEntry identification : identifications) {
            proteinNamesToIdentifications.putIfAbsent(identification.getTitle(), new MascotIdentifications());
            ((MascotIdentifications)proteinNamesToIdentifications.get(identification.getTitle())).add(identification);
        }
        return proteinNamesToIdentifications;
    }

    private static void sortByMascotScore(MascotIdentifications identifications) {
        Collections.sort(identifications, new Comparator<MascotEntry>(){

            @Override
            public int compare(MascotEntry o1, MascotEntry o2) {
                return Integer.valueOf(o2.getMascotScore()).compareTo(o1.getMascotScore());
            }
        });
    }
}

