/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.filechooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.filechooser.FileFilter;
import org.sing_group.gc4s.ComponentFactory;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.filechooser.FileChooserListener;
import org.sing_group.gc4s.filechooser.JFileChooserConfiguration;
import org.sing_group.gc4s.ui.icons.Icons;
import org.sing_group.gc4s.utilities.FileDrop;

public class JFileChooserPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_FILES_LABEL = "File: ";
    public static final ImageIcon DEFAULT_ICON_BROWSE = Icons.ICON_BROWSE_16;
    public static final SelectionMode DEFAULT_SELECTION_MODE = SelectionMode.FILES_DIRECTORIES;
    public static final boolean DEFAULT_ALLOW_ALL_FILTER = true;
    public static final List<FileFilter> DEFAULT_FILE_FILTERS = Collections.emptyList();
    private JFileChooser filechooser;
    private Mode mode;
    private AbstractAction browseAction;
    private JButton btnBrowse;
    private JLabel lblFile;
    private String lblFileText;
    private JTextField fileName;
    private File selectedFile = null;
    private String requiredFileExtension = null;
    private JFileChooserConfiguration fileChooserConfiguration;
    private boolean useSharedLastFileFilter = false;
    private static FileFilter LAST_FILE_FILTER;
    private FileFilter lastFileFilter;

    public JFileChooserPanel(Mode mode) {
        this(mode, new JFileChooser(), DEFAULT_ICON_BROWSE, DEFAULT_FILES_LABEL, null, DEFAULT_SELECTION_MODE);
    }

    public JFileChooserPanel(Mode mode, String requiredFileExtension) {
        this(mode, new JFileChooser(), DEFAULT_ICON_BROWSE, DEFAULT_FILES_LABEL, requiredFileExtension, SelectionMode.FILES_DIRECTORIES);
    }

    public JFileChooserPanel(Mode mode, JFileChooser filechooser, String requiredFileExtension) {
        this(mode, filechooser, DEFAULT_ICON_BROWSE, DEFAULT_FILES_LABEL, requiredFileExtension, DEFAULT_SELECTION_MODE);
    }

    public JFileChooserPanel(Mode mode, SelectionMode selectionMode, JFileChooser filechooser) {
        this(mode, filechooser, DEFAULT_ICON_BROWSE, DEFAULT_FILES_LABEL, null, selectionMode);
    }

    public JFileChooserPanel(Mode mode, JFileChooser filechooser) {
        this(mode, filechooser, DEFAULT_ICON_BROWSE, DEFAULT_FILES_LABEL, null, DEFAULT_SELECTION_MODE);
    }

    public JFileChooserPanel(Mode mode, JFileChooser filechooser, String labelFileText, SelectionMode selectionMode) {
        this(mode, filechooser, DEFAULT_ICON_BROWSE, labelFileText, null, selectionMode);
    }

    public JFileChooserPanel(Mode mode, JFileChooser filechooser, ImageIcon browseIcon, String labelFileText, String requiredFileExtension, SelectionMode selectionMode) {
        this(mode, filechooser, browseIcon, labelFileText, requiredFileExtension, selectionMode, true, DEFAULT_FILE_FILTERS);
    }

    public JFileChooserPanel(Mode mode, JFileChooser filechooser, ImageIcon browseIcon, String labelFileText, String requiredFileExtension, SelectionMode selectionMode, boolean allowAll, List<FileFilter> fileFilters) {
        this.filechooser = filechooser;
        this.lblFileText = labelFileText;
        if (mode.equals((Object)Mode.SAVE)) {
            this.requiredFileExtension = requiredFileExtension;
        }
        this.mode = mode;
        this.fileChooserConfiguration = new JFileChooserConfiguration(selectionMode.getFileSelectionMode(), fileFilters, allowAll);
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.lblFile = new JLabel(this.lblFileText);
        this.fileName = new JTextField("", 20);
        this.fileName.setEditable(false);
        this.fileName.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JFileChooserPanel.this.fileNameUpdated();
            }
        });
        this.fileName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 3) {
                    JFileChooserPanel.this.onBrowse();
                }
            }
        });
        new FileDrop(this.fileName, new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] files) {
                if (files.length > 0) {
                    JFileChooserPanel.this.setSelectedFile(files[0]);
                }
            }
        });
        this.browseAction = new AbstractAction("Browse", DEFAULT_ICON_BROWSE){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooserPanel.this.onBrowse();
            }
        };
        this.btnBrowse = ComponentFactory.createButton(this.browseAction, true, "Browse file", false);
        this.add((Component)this.lblFile, "West");
        this.add((Component)this.fileName, "Center");
        this.add((Component)this.btnBrowse, "East");
    }

    private void fileNameUpdated() {
        this.fireFileChoosedEvent();
    }

    private void fireFileChoosedEvent() {
        Arrays.asList(this.getFileChooserListeners()).forEach(l -> l.onFileChoosed(new ChangeEvent(this)));
    }

    private void onBrowse() {
        JFileChooser fileChooser = this.getConfiguredFileChooser();
        int returnVal = this.mode.equals((Object)Mode.SAVE) ? fileChooser.showSaveDialog(this) : fileChooser.showOpenDialog(this);
        this.saveLastFileFilter(fileChooser.getFileFilter());
        if (returnVal == 0) {
            this.setSelectedFile(fileChooser.getSelectedFile());
        }
        this.clearFileChooser();
    }

    private void saveLastFileFilter(FileFilter fileFilter) {
        this.lastFileFilter = fileFilter;
        if (this.useSharedLastFileFilter) {
            LAST_FILE_FILTER = this.lastFileFilter;
        }
    }

    private JFileChooser getConfiguredFileChooser() {
        JFileChooser fileChooser = this.getFilechooser();
        this.fileChooserConfiguration.configure(fileChooser);
        this.configureLastFileFilter(fileChooser);
        return fileChooser;
    }

    private void configureLastFileFilter(JFileChooser fileChooser) {
        if (this.useSharedLastFileFilter) {
            if (!JFileChooserPanel.setFileFilter(fileChooser, LAST_FILE_FILTER) && JFileChooserPanel.isAcceptAllFileFilter(LAST_FILE_FILTER)) {
                this.setAcceptAllFileFilter(fileChooser);
            }
        } else {
            JFileChooserPanel.setFileFilter(fileChooser, this.lastFileFilter);
        }
    }

    private static boolean setFileFilter(JFileChooser fileChooser, FileFilter filter) {
        if (filter != null && JFileChooserPanel.containsFilter(fileChooser, filter)) {
            fileChooser.setFileFilter(filter);
            return true;
        }
        return false;
    }

    private static boolean containsFilter(JFileChooser fileChooser, FileFilter filter) {
        return JFileChooserPanel.getFileFilters(fileChooser).contains(filter);
    }

    private static List<FileFilter> getFileFilters(JFileChooser fileChooser) {
        return Arrays.asList(fileChooser.getChoosableFileFilters());
    }

    private static boolean isAcceptAllFileFilter(FileFilter filter) {
        return filter != null && filter.getClass().getSimpleName().equals("AcceptAllFileFilter");
    }

    private void setAcceptAllFileFilter(JFileChooser fileChooser) {
        Optional<FileFilter> acceptAllFileFilter = JFileChooserPanel.findAcceptAllFileFilter(fileChooser);
        if (acceptAllFileFilter.isPresent()) {
            fileChooser.setFileFilter(acceptAllFileFilter.get());
        }
    }

    private static Optional<FileFilter> findAcceptAllFileFilter(JFileChooser fileChooser) {
        return JFileChooserPanel.getFileFilters(fileChooser).stream().filter(JFileChooserPanel::isAcceptAllFileFilter).findAny();
    }

    private void clearFileChooser() {
        this.getFilechooser().setFileSelectionMode(2);
    }

    public void setSelectedFile(File file) {
        this.selectedFile = file;
        if (this.requiredFileExtension != null && !file.getName().toLowerCase().endsWith("." + this.requiredFileExtension)) {
            this.selectedFile = new File(file.getAbsolutePath() + "." + this.requiredFileExtension);
        }
        this.fileName.setText(this.selectedFile.getAbsolutePath());
        this.fileName.setToolTipText(this.selectedFile.getAbsolutePath());
        this.filechooser.setSelectedFile(file);
    }

    public JFileChooser getFilechooser() {
        return this.filechooser;
    }

    public AbstractAction getBrowseAction() {
        return this.browseAction;
    }

    public JLabel getComponentLabelFile() {
        return this.lblFile;
    }

    public JTextField getComponentFileName() {
        return this.fileName;
    }

    public JButton getComponentButtonBrowse() {
        return this.btnBrowse;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public void setUseSharedLastFileFilter(boolean use) {
        this.useSharedLastFileFilter = use;
    }

    public static void clearSharedLastFileFilter() {
        LAST_FILE_FILTER = null;
    }

    public synchronized void addFileChooserListener(FileChooserListener l) {
        this.listenerList.add(FileChooserListener.class, l);
    }

    public synchronized FileChooserListener[] getFileChooserListeners() {
        return (FileChooserListener[])this.listenerList.getListeners(FileChooserListener.class);
    }

    public static enum SelectionMode {
        FILES(0),
        DIRECTORIES(1),
        FILES_DIRECTORIES(2);

        private int fileSelectionMode;

        private SelectionMode(int fileSelectionMode) {
            this.fileSelectionMode = fileSelectionMode;
        }

        public int getFileSelectionMode() {
            return this.fileSelectionMode;
        }
    }

    public static enum Mode {
        OPEN,
        SAVE;

    }
}

