/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.list;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.InvalidClassException;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.ComponentFactory;
import org.sing_group.gc4s.list.ExtendedDefaultListModel;
import org.sing_group.gc4s.list.FilteredListModel;

public class JListPanel<E>
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final ImageIcon ICON_ARROW_DOWN = new ImageIcon(JListPanel.class.getResource("icons/down.png"));
    protected static final ImageIcon ICON_ARROW_UP = new ImageIcon(JListPanel.class.getResource("icons/up.png"));
    protected static final ImageIcon ICON_REMOVE = new ImageIcon(JListPanel.class.getResource("icons/remove.png"));
    protected static final ImageIcon ICON_CLEAR = new ImageIcon(JListPanel.class.getResource("icons/clear.png"));
    protected static final ImageIcon ICON_SELECT_ALL = new ImageIcon(JListPanel.class.getResource("icons/check.png"));
    private JList<E> list;
    private ExtendedDefaultListModel<E> listModel;
    private FilteredListModel<E> filteredListModel;
    private JButton btnMoveDown;
    private JButton btnMoveUp;
    private JButton btnRemove;
    private JButton btnClearSelection;
    private JButton btnSelectAll;
    private JToggleButton regexButton;
    private JPanel northPanel;
    private JPanel buttonsPanel;
    private JPanel filterPanel;
    private JTextField filterTextField;
    private AbstractAction actionMoveDown;
    private AbstractAction actionMoveUp;
    private AbstractAction actionRemoveElements;
    private AbstractAction actionSelectAll;
    private AbstractAction actionClearSelection;
    private boolean buttons;
    private boolean filter;

    public JListPanel(JList<E> list) throws InvalidClassException {
        this(list, true, true);
    }

    public JListPanel(JList<E> list, boolean buttons, boolean filter) throws InvalidClassException {
        this.list = list;
        if (!(list.getModel() instanceof ExtendedDefaultListModel)) {
            throw new InvalidClassException("List should have a ExtendedDefaultModel");
        }
        this.listModel = (ExtendedDefaultListModel)list.getModel();
        this.filteredListModel = new FilteredListModel<E>(this.listModel);
        this.list.setModel(this.filteredListModel);
        this.buttons = buttons;
        this.filter = filter;
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.add(this.getNorthPane(), "North");
        this.add((Component)new JScrollPane(this.list), "Center");
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JListPanel.this.checkActionButtons();
            }
        });
        this.listModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                JListPanel.this.checkActionButtons();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                JListPanel.this.checkActionButtons();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                JListPanel.this.checkActionButtons();
            }
        });
    }

    private Component getNorthPane() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel();
            this.northPanel.setLayout(new GridLayout(0, 1));
            this.getButtonsPane();
            if (this.buttons) {
                this.northPanel.add(this.getButtonsPane());
            }
            if (this.filter) {
                this.northPanel.add(this.getFilterPane());
            }
        }
        return this.northPanel;
    }

    private Component getFilterPane() {
        if (this.filterPanel == null) {
            this.filterPanel = new JPanel(new BorderLayout());
            this.filterTextField = new JXTextField("Filter", Color.LIGHT_GRAY);
            this.filterPanel.add((Component)this.filterTextField, "Center");
            this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent arg0) {
                }

                @Override
                public void insertUpdate(DocumentEvent arg0) {
                    JListPanel.this.filterChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent arg0) {
                    JListPanel.this.filterChanged();
                }
            });
            this.regexButton = ComponentFactory.createToggleButton(null, null, false, new AbstractAction("(.*)"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JListPanel.this.filterChanged();
                }
            });
            this.regexButton.setToolTipText("Select this option to apply the filter as a regular expression");
            this.filterPanel.add((Component)this.regexButton, "East");
        }
        return this.filterPanel;
    }

    protected void filterChanged() {
        this.filteredListModel.setFilter(new FilteredListModel.Filter(){

            @Override
            public boolean accept(Object element) {
                String string = element.toString();
                String filter = JListPanel.this.filterTextField.getText();
                if (!JListPanel.this.regexButton.isSelected()) {
                    if (string.contains(filter)) {
                        return true;
                    }
                } else {
                    try {
                        if (string.matches(".*" + filter + ".*")) {
                            return true;
                        }
                    }
                    catch (PatternSyntaxException ex) {
                        return false;
                    }
                }
                return false;
            }
        });
    }

    private Component getButtonsPane() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            BoxLayout layout = new BoxLayout(this.buttonsPanel, 0);
            this.buttonsPanel.setLayout(layout);
            this.actionMoveDown = new AbstractAction("Move down", ICON_ARROW_DOWN){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JListPanel.this.moveDownSelectedElement();
                }
            };
            this.actionMoveUp = new AbstractAction("Move up", ICON_ARROW_UP){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JListPanel.this.moveUpSelectedElement();
                }
            };
            this.actionRemoveElements = new AbstractAction("Remove", ICON_REMOVE){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JListPanel.this.removeSelectedElements();
                }
            };
            this.actionClearSelection = new AbstractAction("Clear selection", ICON_CLEAR){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JListPanel.this.clearSelection();
                }
            };
            this.actionSelectAll = new AbstractAction("Select all", ICON_SELECT_ALL){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JListPanel.this.selectAll();
                }
            };
            this.btnMoveDown = ComponentFactory.createButton(this.actionMoveDown, false, "Moves down the selected element", false);
            this.btnMoveUp = ComponentFactory.createButton(this.actionMoveUp, false, "Moves up the selected element", false);
            this.btnRemove = ComponentFactory.createButton(this.actionRemoveElements, false, "Removes the selected elements", false);
            this.btnSelectAll = ComponentFactory.createButton(this.actionSelectAll, this.listModel.getSize() > 0, "Select all the elements", false);
            this.btnClearSelection = ComponentFactory.createButton(this.actionClearSelection, false, "Clear the current selection", false);
            this.buttonsPanel.add(Box.createHorizontalGlue());
            this.buttonsPanel.add(this.btnMoveDown);
            this.buttonsPanel.add(this.btnMoveUp);
            this.buttonsPanel.add(this.btnRemove);
            this.buttonsPanel.add(this.btnSelectAll);
            this.buttonsPanel.add(this.btnClearSelection);
            this.buttonsPanel.add(Box.createHorizontalGlue());
        }
        return this.buttonsPanel;
    }

    private void moveDownSelectedElement() {
        if (this.listModel.moveDown(this.list.getSelectedIndex())) {
            this.list.setSelectedIndex(this.list.getSelectedIndex() + 1);
        }
    }

    private void moveUpSelectedElement() {
        if (this.listModel.moveUp(this.list.getSelectedIndex())) {
            this.list.setSelectedIndex(this.list.getSelectedIndex() - 1);
        }
    }

    private void removeSelectedElements() {
        this.list.getSelectedValuesList().forEach(e -> this.listModel.removeElement(e));
        this.list.clearSelection();
        this.list.updateUI();
    }

    private void checkActionButtons() {
        int selectedIndexesCount = this.list.getSelectedIndices().length;
        boolean moveEnabled = selectedIndexesCount == 1 && this.listModel.getSize() > 1;
        this.btnMoveUp.setEnabled(moveEnabled);
        this.btnMoveDown.setEnabled(moveEnabled);
        this.btnClearSelection.setEnabled(selectedIndexesCount > 0);
        this.btnRemove.setEnabled(selectedIndexesCount > 0);
        this.btnSelectAll.setEnabled(selectedIndexesCount < this.listModel.getSize() && this.listModel.getSize() > 0);
    }

    private void clearSelection() {
        this.list.clearSelection();
    }

    private void selectAll() {
        int size = this.listModel.getSize();
        int[] selectedIndexes = new int[size];
        for (int i = 0; i < size; ++i) {
            selectedIndexes[i] = i;
        }
        this.list.setSelectedIndices(selectedIndexes);
    }

    public JButton getBtnMoveUp() {
        return this.btnMoveUp;
    }

    public JButton getBtnMoveDown() {
        return this.btnMoveDown;
    }

    public JButton getBtnRemoveElements() {
        return this.btnMoveDown;
    }

    public JButton getBtnClearSelection() {
        return this.btnClearSelection;
    }

    public JButton getBtnSelectAll() {
        return this.btnSelectAll;
    }

    public AbstractAction getActionMoveUp() {
        return this.actionMoveUp;
    }

    public AbstractAction getActionMoveDown() {
        return this.actionMoveDown;
    }

    public AbstractAction getActionRemoveElements() {
        return this.actionRemoveElements;
    }

    public AbstractAction getActionClearSelection() {
        return this.actionClearSelection;
    }

    public AbstractAction getActionSelectAll() {
        return this.actionSelectAll;
    }

    public JList<E> getList() {
        return this.list;
    }
}

