/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import weka.core.Instances;
import weka.gui.Messages;

public class AttributeSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 627131485290359194L;
    protected JButton m_IncludeAll;
    protected JButton m_RemoveAll;
    protected JButton m_Invert;
    protected JButton m_Pattern;
    protected JTable m_Table;
    protected AttributeTableModel m_Model;
    protected String m_PatternRegEx;

    public AttributeSelectionPanel() {
        this(true, true, true, true);
    }

    public AttributeSelectionPanel(boolean include, boolean remove, boolean invert, boolean pattern) {
        Messages.getInstance();
        this.m_IncludeAll = new JButton(Messages.getString("AttributeSelectionPanel_IncludeAll_JButton_Text"));
        Messages.getInstance();
        this.m_RemoveAll = new JButton(Messages.getString("AttributeSelectionPanel_RemoveAll_JButton_Text"));
        Messages.getInstance();
        this.m_Invert = new JButton(Messages.getString("AttributeSelectionPanel_Invert_JButton_Text"));
        Messages.getInstance();
        this.m_Pattern = new JButton(Messages.getString("AttributeSelectionPanel_Pattern_JButton_Text"));
        this.m_Table = new JTable();
        this.m_PatternRegEx = "";
        Messages.getInstance();
        this.m_IncludeAll.setToolTipText(Messages.getString("AttributeSelectionPanel_IncludeAll_SetToolTipText_Text"));
        this.m_IncludeAll.setEnabled(false);
        this.m_IncludeAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributeSelectionPanel.this.m_Model.includeAll();
            }
        });
        Messages.getInstance();
        this.m_RemoveAll.setToolTipText(Messages.getString("AttributeSelectionPanel_RemoveAll_SetToolTipText_Text"));
        this.m_RemoveAll.setEnabled(false);
        this.m_RemoveAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributeSelectionPanel.this.m_Model.removeAll();
            }
        });
        Messages.getInstance();
        this.m_Invert.setToolTipText(Messages.getString("AttributeSelectionPanel_Invert_SetToolTipText_Text"));
        this.m_Invert.setEnabled(false);
        this.m_Invert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributeSelectionPanel.this.m_Model.invert();
            }
        });
        Messages.getInstance();
        this.m_Pattern.setToolTipText(Messages.getString("AttributeSelectionPanel_Pattern_SetToolTipText_Text"));
        this.m_Pattern.setEnabled(false);
        this.m_Pattern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Container container = AttributeSelectionPanel.this.m_Pattern.getParent();
                Messages.getInstance();
                String pattern = JOptionPane.showInputDialog(container, Messages.getString("AttributeSelectionPanel_Pattern_JOptionPaneShowInputDialog_Text"), AttributeSelectionPanel.this.m_PatternRegEx);
                if (pattern != null) {
                    try {
                        Pattern.compile(pattern);
                        AttributeSelectionPanel.this.m_PatternRegEx = pattern;
                        AttributeSelectionPanel.this.m_Model.pattern(pattern);
                    }
                    catch (Exception ex) {
                        Container container2 = AttributeSelectionPanel.this.m_Pattern.getParent();
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("AttributeSelectionPanel_Exception_JOptionPaneShowMessageDialog_Text_First")).append(pattern);
                        Messages.getInstance();
                        String string = stringBuilder2.append(Messages.getString("AttributeSelectionPanel_Exception_JOptionPaneShowMessageDialog_Text_Second")).append(ex).toString();
                        Messages.getInstance();
                        JOptionPane.showMessageDialog(container2, string, Messages.getString("AttributeSelectionPanel_Exception_JOptionPaneShowMessageDialog_Text_Third"), 0);
                    }
                }
            }
        });
        this.m_Table.setSelectionMode(0);
        this.m_Table.setColumnSelectionAllowed(false);
        this.m_Table.setPreferredScrollableViewportSize(new Dimension(250, 150));
        JPanel p1 = new JPanel();
        p1.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        p1.setLayout(new GridLayout(1, 4, 5, 5));
        if (include) {
            p1.add(this.m_IncludeAll);
        }
        if (remove) {
            p1.add(this.m_RemoveAll);
        }
        if (invert) {
            p1.add(this.m_Invert);
        }
        if (pattern) {
            p1.add(this.m_Pattern);
        }
        this.setLayout(new BorderLayout());
        if (include || remove || invert || pattern) {
            this.add((Component)p1, "North");
        }
        this.add((Component)new JScrollPane(this.m_Table), "Center");
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.m_Table.getPreferredScrollableViewportSize();
    }

    public void setPreferredScrollableViewportSize(Dimension d) {
        this.m_Table.setPreferredScrollableViewportSize(d);
    }

    public void setInstances(Instances newInstances) {
        if (this.m_Model == null) {
            this.m_Model = new AttributeTableModel(newInstances);
            this.m_Table.setModel(this.m_Model);
            TableColumnModel tcm = this.m_Table.getColumnModel();
            tcm.getColumn(0).setMaxWidth(60);
            tcm.getColumn(1).setMaxWidth(tcm.getColumn(1).getMinWidth());
            tcm.getColumn(2).setMinWidth(100);
        } else {
            this.m_Model.setInstances(newInstances);
            this.m_Table.clearSelection();
        }
        this.m_IncludeAll.setEnabled(true);
        this.m_RemoveAll.setEnabled(true);
        this.m_Invert.setEnabled(true);
        this.m_Pattern.setEnabled(true);
        this.m_Table.sizeColumnsToFit(2);
        this.m_Table.revalidate();
        this.m_Table.repaint();
    }

    public int[] getSelectedAttributes() {
        return this.m_Model == null ? null : this.m_Model.getSelectedAttributes();
    }

    public void setSelectedAttributes(boolean[] selected) throws Exception {
        if (this.m_Model != null) {
            this.m_Model.setSelectedAttributes(selected);
        }
    }

    public TableModel getTableModel() {
        return this.m_Model;
    }

    public ListSelectionModel getSelectionModel() {
        return this.m_Table.getSelectionModel();
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                Messages.getInstance();
                throw new Exception(Messages.getString("AttributeSelectionPanel_Main_Exception_Text"));
            }
            Instances i = new Instances(new BufferedReader(new FileReader(args[0])));
            AttributeSelectionPanel asp = new AttributeSelectionPanel();
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("AttributeSelectionPanel_Main_JFrame_Text"));
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)asp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            asp.setInstances(i);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    class AttributeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4152987434024338064L;
        protected Instances m_Instances;
        protected boolean[] m_Selected;

        public AttributeTableModel(Instances instances) {
            this.setInstances(instances);
        }

        public void setInstances(Instances instances) {
            this.m_Instances = instances;
            this.m_Selected = new boolean[this.m_Instances.numAttributes()];
        }

        public int getRowCount() {
            return this.m_Selected.length;
        }

        public int getColumnCount() {
            return 3;
        }

        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return new Integer(row + 1);
                }
                case 1: {
                    return new Boolean(this.m_Selected[row]);
                }
                case 2: {
                    return this.m_Instances.attribute(row).name();
                }
            }
            return null;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    Messages.getInstance();
                    return new String(Messages.getString("AttributeSelectionPanel_GetColumnName_Text_First"));
                }
                case 1: {
                    Messages.getInstance();
                    return new String(Messages.getString("AttributeSelectionPanel_GetColumnName_Text_Second"));
                }
                case 2: {
                    Messages.getInstance();
                    return new String(Messages.getString("AttributeSelectionPanel_GetColumnName_Text_Third"));
                }
            }
            return null;
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                this.m_Selected[row] = (Boolean)value;
                this.fireTableRowsUpdated(0, this.m_Selected.length);
            }
        }

        public Class getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public int[] getSelectedAttributes() {
            int[] r1 = new int[this.getRowCount()];
            int selCount = 0;
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.m_Selected[i]) continue;
                r1[selCount++] = i;
            }
            int[] result = new int[selCount];
            System.arraycopy(r1, 0, result, 0, selCount);
            return result;
        }

        public void includeAll() {
            for (int i = 0; i < this.m_Selected.length; ++i) {
                this.m_Selected[i] = true;
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }

        public void removeAll() {
            for (int i = 0; i < this.m_Selected.length; ++i) {
                this.m_Selected[i] = false;
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }

        public void invert() {
            for (int i = 0; i < this.m_Selected.length; ++i) {
                this.m_Selected[i] = !this.m_Selected[i];
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }

        public void pattern(String pattern) {
            for (int i = 0; i < this.m_Selected.length; ++i) {
                this.m_Selected[i] = Pattern.matches(pattern, this.m_Instances.attribute(i).name());
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }

        public void setSelectedAttributes(boolean[] selected) throws Exception {
            if (selected.length != this.m_Selected.length) {
                throw new Exception("Supplied array does not have the same number of elements as there are attributes!");
            }
            for (int i = 0; i < selected.length; ++i) {
                this.m_Selected[i] = selected[i];
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }
    }
}

