/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core;

import es.uvigo.ei.aibench.Launcher;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import java.util.Iterator;
import org.platonos.pluginengine.Plugin;

public class PluginsObjectInputStream
extends ObjectInputStream {
    private Plugin plugin;

    public PluginsObjectInputStream(InputStream in, Plugin plugin) throws IOException {
        super(in);
        this.plugin = plugin;
    }

    public PluginsObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
        Class<?> c = null;
        String descName = desc.getName();
        if (descName.matches("\\[L.*;")) {
            String className = descName.substring(2, descName.length() - 1);
            c = Array.newInstance(this.loadClass(className), 0).getClass();
        } else {
            c = this.loadClass(descName);
        }
        if (c == null) {
            throw new ClassNotFoundException(descName);
        }
        return c;
    }

    private Class<?> loadClass(String descName) {
        try {
            if (this.plugin != null) {
                return this.plugin.getPluginClassLoader().loadClass(descName);
            }
            Iterator iterator = Launcher.pluginEngine.getPlugins().iterator();
            if (iterator.hasNext()) {
                Object o = iterator.next();
                Plugin p = (Plugin)o;
                return p.getPluginClassLoader().loadClass(descName);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }
}

