/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core;

import es.uvigo.ei.aibench.core.Base64Coder;
import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.core.ParamSource;
import es.uvigo.ei.aibench.core.ParamSpec;
import es.uvigo.ei.aibench.core.clipboard.ClipboardItem;
import es.uvigo.ei.aibench.core.operation.annotation.Direction;
import es.uvigo.ei.aibench.core.operation.annotation.Port;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public final class CoreUtils {
    private static final Logger LOGGER = Logger.getLogger((String)CoreUtils.class.getName());
    public static final Comparator<Port> PORT_COMPARATOR = new Comparator<Port>(){

        @Override
        public int compare(Port o1, Port o2) {
            int cmpOrder = o1.order() - o2.order();
            if (cmpOrder == 0) {
                if (o1.direction() == o2.direction()) {
                    int cmpName = o1.name().compareTo(o2.name());
                    if (cmpName == 0) {
                        return o1.description().compareTo(o2.description());
                    }
                    return cmpName;
                }
                return o1.direction() == Direction.INPUT ? -1 : 1;
            }
            return cmpOrder;
        }
    };
    private static final Class<?>[] WRAPPER_CLASSES = new Class[]{Character.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class};

    private static final boolean isPrimitiveOrWrapper(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        for (Class<?> wrapper : WRAPPER_CLASSES) {
            if (!wrapper.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    private static final Object stringToPrimitive(Class<?> type, String value) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException {
        if (value == null) {
            throw new NullPointerException("value can't be null");
        }
        if (!type.isPrimitive() && !Arrays.asList(WRAPPER_CLASSES).contains(type)) {
            throw new IllegalArgumentException("type must be primitive or wrapper class");
        }
        if (type.equals(Character.TYPE) || type.equals(Character.class)) {
            return Character.valueOf(value.charAt(0));
        }
        for (Class<?> wrapperClass : WRAPPER_CLASSES) {
            Class fieldType = (Class)wrapperClass.getField("TYPE").get(wrapperClass);
            if (!type.equals(wrapperClass) && !fieldType.equals(type)) continue;
            String methodName = "parse" + Character.toUpperCase(fieldType.getName().charAt(0)) + fieldType.getName().substring(1);
            return wrapperClass.getMethod(methodName, String.class).invoke(null, value);
        }
        throw new IllegalArgumentException("type must be a primitive");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setPortValue(Object operation, Method method, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException, NoSuchMethodException, InstantiationException {
        Port port = method.getAnnotation(Port.class);
        if (port == null || port.direction() != Direction.INPUT || method.getParameterTypes().length != 1) throw new IllegalArgumentException("method is not an input port");
        if (value == null) {
            if (!port.allowNull()) throw new NullPointerException(port.name() + " does not allow null values");
            method.invoke(operation, new Object[]{null});
            return;
        } else {
            Object parameterValue;
            Class<?> parameterType = method.getParameterTypes()[0];
            if (CoreUtils.isPrimitiveOrWrapper(parameterType)) {
                parameterValue = CoreUtils.stringToPrimitive(parameterType, value);
            } else if (parameterType.isEnum()) {
                Method valueOf = parameterType.getMethod("valueOf", String.class);
                parameterValue = valueOf.invoke(null, value);
            } else {
                Constructor<?> constructor = parameterType.getConstructor(String.class);
                parameterValue = constructor.newInstance(value);
            }
            method.invoke(operation, parameterValue);
        }
    }

    public static void setDefaultPortValues(Object operation) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException, NoSuchMethodException, InstantiationException {
        CoreUtils.setDefaultPortValues(operation, false);
    }

    public static void setDefaultPortValues(Object operation, boolean setEmptyDefaultValues) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException, NoSuchMethodException, InstantiationException {
        Class<?> clazz = operation.getClass();
        TreeMap<Port, Method> inPorts = new TreeMap<Port, Method>(PORT_COMPARATOR);
        for (Method method : clazz.getMethods()) {
            Port port = method.getAnnotation(Port.class);
            if (port == null || method.getParameterTypes().length != 1) continue;
            inPorts.put(port, method);
        }
        for (Map.Entry entry : inPorts.entrySet()) {
            Method method;
            Port port = (Port)entry.getKey();
            method = (Method)entry.getValue();
            if (port.defaultValue().equals("")) {
                if (!setEmptyDefaultValues) continue;
                CoreUtils.setPortValue(operation, method, port.defaultValue());
                continue;
            }
            CoreUtils.setPortValue(operation, method, port.defaultValue());
        }
    }

    public static ParamSpec[] createParams(List<?> params) {
        ParamSpec[] paramsSpec = new ParamSpec[params.size()];
        for (int p = 0; p < params.size(); ++p) {
            paramsSpec[p] = CoreUtils.createParam(params.get(p));
        }
        return paramsSpec;
    }

    private static ParamSpec[] createParams(Object[] array) {
        ParamSpec[] specArray = new ParamSpec[array.length];
        for (int i = 0; i < specArray.length; ++i) {
            specArray[i] = CoreUtils.createParam(array[i]);
        }
        return specArray;
    }

    private static ParamSpec[] createParams(int[] array) {
        ParamSpec[] specArray = new ParamSpec[array.length];
        for (int i = 0; i < specArray.length; ++i) {
            specArray[i] = CoreUtils.createParam(new Integer(array[i]));
        }
        return specArray;
    }

    private static ParamSpec[] createParams(boolean[] array) {
        ParamSpec[] specArray = new ParamSpec[array.length];
        for (int i = 0; i < specArray.length; ++i) {
            specArray[i] = CoreUtils.createParam(new Boolean(array[i]));
        }
        return specArray;
    }

    private static ParamSpec[] createParams(char[] array) {
        ParamSpec[] specArray = new ParamSpec[array.length];
        for (int i = 0; i < specArray.length; ++i) {
            specArray[i] = CoreUtils.createParam(new Character(array[i]));
        }
        return specArray;
    }

    private static ParamSpec[] createParams(double[] array) {
        ParamSpec[] specArray = new ParamSpec[array.length];
        for (int i = 0; i < specArray.length; ++i) {
            specArray[i] = CoreUtils.createParam(new Double(array[i]));
        }
        return specArray;
    }

    private static ParamSpec[] createParams(float[] array) {
        ParamSpec[] specArray = new ParamSpec[array.length];
        for (int i = 0; i < specArray.length; ++i) {
            specArray[i] = CoreUtils.createParam(new Float(array[i]));
        }
        return specArray;
    }

    private static ParamSpec[] createParams(long[] array) {
        ParamSpec[] specArray = new ParamSpec[array.length];
        for (int i = 0; i < specArray.length; ++i) {
            specArray[i] = CoreUtils.createParam(new Long(array[i]));
        }
        return specArray;
    }

    private static ParamSpec[] createParams(short[] array) {
        ParamSpec[] specArray = new ParamSpec[array.length];
        for (int i = 0; i < specArray.length; ++i) {
            specArray[i] = CoreUtils.createParam(new Short(array[i]));
        }
        return specArray;
    }

    private static ParamSpec[] createParams(byte[] array) {
        ParamSpec[] specArray = new ParamSpec[array.length];
        for (int i = 0; i < specArray.length; ++i) {
            specArray[i] = CoreUtils.createParam(new Byte(array[i]));
        }
        return specArray;
    }

    private static ParamSpec createParam(Object param) {
        if (param == null) {
            return new ParamSpec("null", Object.class, null, ParamSource.CLIPBOARD);
        }
        Class<?> clazz = param.getClass();
        if (clazz.isEnum()) {
            return new ParamSpec("enum", clazz, param, ParamSource.ENUM);
        }
        if (clazz.isArray()) {
            if (clazz.equals(new int[0].getClass())) {
                return new ParamSpec("array", Integer[].class, CoreUtils.createParams((int[])param));
            }
            if (clazz.equals(new byte[0].getClass())) {
                return new ParamSpec("array", Byte[].class, CoreUtils.createParams((byte[])param));
            }
            if (clazz.equals(new short[0].getClass())) {
                return new ParamSpec("array", Short[].class, CoreUtils.createParams((short[])param));
            }
            if (clazz.equals(new long[0].getClass())) {
                return new ParamSpec("array", Long[].class, CoreUtils.createParams((long[])param));
            }
            if (clazz.equals(new float[0].getClass())) {
                return new ParamSpec("array", Float[].class, CoreUtils.createParams((float[])param));
            }
            if (clazz.equals(new double[0].getClass())) {
                return new ParamSpec("array", Double[].class, CoreUtils.createParams((double[])param));
            }
            if (clazz.equals(new char[0].getClass())) {
                return new ParamSpec("array", Character[].class, CoreUtils.createParams((char[])param));
            }
            if (clazz.equals(new boolean[0].getClass())) {
                return new ParamSpec("array", Boolean[].class, CoreUtils.createParams((boolean[])param));
            }
            return new ParamSpec("array", clazz, CoreUtils.createParams((Object[])param));
        }
        ClipboardItem item = Core.getInstance().getClipboard().getClipboardItem(param);
        if (item != null) {
            return new ParamSpec("item", clazz, item, ParamSource.CLIPBOARD);
        }
        if (clazz.equals(Integer.class)) {
            return new ParamSpec("integer", Integer.class, param, ParamSource.STRING_CONSTRUCTOR);
        }
        if (clazz.equals(String.class)) {
            return new ParamSpec("string", String.class, param, ParamSource.STRING_CONSTRUCTOR);
        }
        if (clazz.equals(Byte.class)) {
            return new ParamSpec("byte", Byte.class, param, ParamSource.STRING_CONSTRUCTOR);
        }
        if (clazz.equals(Short.class)) {
            return new ParamSpec("short", Short.class, param, ParamSource.STRING_CONSTRUCTOR);
        }
        if (clazz.equals(Long.class)) {
            return new ParamSpec("long", Long.class, param, ParamSource.STRING_CONSTRUCTOR);
        }
        if (clazz.equals(Float.class)) {
            return new ParamSpec("float", Float.class, param, ParamSource.STRING_CONSTRUCTOR);
        }
        if (clazz.equals(Double.class)) {
            return new ParamSpec("double", Double.class, param, ParamSource.STRING_CONSTRUCTOR);
        }
        if (clazz.equals(Character.class)) {
            return new ParamSpec("char", Character.class, param, ParamSource.STRING_CONSTRUCTOR);
        }
        if (clazz.equals(Boolean.class)) {
            return new ParamSpec("boolean", Boolean.class, param, ParamSource.STRING_CONSTRUCTOR);
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            return new ParamSpec("param", clazz, Base64Coder.encodeSerializableObject((Serializable)param), ParamSource.SERIALIZED);
        }
        return null;
    }

    public static boolean isValidURL(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static void openURL(String url) throws Exception {
        try {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll, FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)("The url '" + url + "' could not be opened"), (Throwable)e);
            throw e;
        }
    }
}

