/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.inputgui;

import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.core.ParamSource;
import es.uvigo.ei.aibench.core.ParamSpec;
import es.uvigo.ei.aibench.core.clipboard.ClipboardItem;
import es.uvigo.ei.aibench.core.clipboard.ClipboardListener;
import es.uvigo.ei.aibench.core.datatypes.Transformer;
import es.uvigo.ei.aibench.core.operation.annotation.Port;
import es.uvigo.ei.aibench.workbench.OperationResultsCollector;
import es.uvigo.ei.aibench.workbench.OperationWrapper;
import es.uvigo.ei.aibench.workbench.ParamsReceiver;
import es.uvigo.ei.aibench.workbench.WaitOperationWrapper;
import es.uvigo.ei.aibench.workbench.Workbench;
import es.uvigo.ei.aibench.workbench.inputgui.AbstractParamProvider;
import es.uvigo.ei.aibench.workbench.inputgui.ArrayParamProvider;
import es.uvigo.ei.aibench.workbench.inputgui.FileParamProvider;
import es.uvigo.ei.aibench.workbench.inputgui.ParamsWindow;
import es.uvigo.ei.aibench.workbench.utilities.PortExtras;
import es.uvigo.ei.aibench.workbench.utilities.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ClipboardParamProvider
extends AbstractParamProvider {
    static final ImageIcon ICON_OPERATIONS = new ImageIcon(ArrayParamProvider.class.getResource("images/operations.png"));
    private static final Logger LOGGER = Logger.getLogger(FileParamProvider.class);
    private static final String REQUIRED = "required";
    private static final String[] KNOWN_PROPERTIES = new String[]{"required"};
    private static final FocusListener FOCUS_LISTENER = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getComponent() instanceof JComboBox) {
                JComboBox combo = (JComboBox)e.getComponent();
                if (combo.isEditable()) {
                    combo.getEditor().selectAll();
                }
            } else if (e.getComponent() instanceof JTextField) {
                ((JTextField)e.getComponent()).selectAll();
            }
        }
    };
    private JPanel panel = new JPanel(new BorderLayout());
    private final boolean hasStringConstructor;
    private JComboBox<Object> combo = null;
    private JTextField textField = null;
    private boolean showCreateButton = true;
    private int countItemsInClipboard = 0;
    private JMenuBar createButton;
    private String nullItemText = "<NULL>";
    private boolean allowTextFieldEmptyString = true;
    private ClipboardParamListener listener = null;

    public ClipboardParamProvider(ParamsReceiver receiver, Port p, Class<?> clazz, Object operationObject) {
        super(receiver, p, clazz, operationObject);
        boolean hasStringConstructor;
        try {
            clazz.getConstructor(String.class);
            hasStringConstructor = true;
        }
        catch (Exception e) {
            hasStringConstructor = false;
        }
        this.hasStringConstructor = hasStringConstructor;
        List<ClipboardItem> listItems = this.listClibpoardItems();
        List<ClipboardItem> listTransformables = this.listClipboardTransformables();
        listTransformables.removeAll(listItems);
        this.countItemsInClipboard = listItems.size() + listTransformables.size();
        this.parseExtras(p.extras());
    }

    private void parseExtras(String extrasString) {
        PortExtras extras = PortExtras.parse(extrasString);
        this.allowTextFieldEmptyString = !extras.containsProperty(REQUIRED);
        PortExtras.warnUnknownExtraProperties(extras, LOGGER, true, KNOWN_PROPERTIES);
    }

    @Override
    public synchronized JComponent getComponent() {
        this.reloadComponent();
        this.createButton = new JMenuBar();
        JMenu menu = this.getOperationsWhichGeneratesPopup(this.clazz);
        if (menu != null) {
            this.createButton.add(menu);
        }
        if (this.showCreateButton) {
            this.panel.add((Component)this.createButton, "East");
        }
        return this.panel;
    }

    public void setNullItemText(String nullItemText) {
        this.nullItemText = nullItemText;
    }

    public String getNullItemText() {
        return this.nullItemText;
    }

    public int countClipboardItems() {
        return this.countItemsInClipboard;
    }

    public boolean isShowingCombo() {
        return this.combo != null;
    }

    public boolean isShowingTextField() {
        return this.textField != null;
    }

    public boolean hasStringConstructor() {
        return this.hasStringConstructor;
    }

    public JComboBox<Object> getCombo() {
        return this.combo;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public synchronized JComponent getCurrentComponent() {
        if (this.isShowingCombo()) {
            return this.getCombo();
        }
        if (this.isShowingTextField()) {
            return this.getTextField();
        }
        return null;
    }

    public synchronized String getCurrentString() {
        if (this.isShowingCombo()) {
            if (this.combo.getSelectedItem() instanceof NullItem) {
                return null;
            }
            if (this.combo.isEditable() && this.combo.getSelectedIndex() == -1) {
                return this.combo.getSelectedItem().toString();
            }
            return "";
        }
        if (this.isShowingTextField()) {
            return this.textField.getText();
        }
        return "";
    }

    public synchronized void clearFields() {
        if (this.isShowingCombo()) {
            this.combo.setSelectedIndex(-1);
        } else if (this.isShowingTextField()) {
            this.textField.setText("");
        }
    }

    public synchronized void setCurrentString(String string) {
        if (this.hasStringConstructor) {
            if (this.isShowingCombo()) {
                this.combo.setSelectedItem(string);
            } else if (this.isShowingTextField()) {
                this.textField.setText(string);
            }
        }
    }

    private List<ClipboardItem> listClibpoardItems() {
        ArrayList<ClipboardItem> items = new ArrayList<ClipboardItem>();
        List clipboardItems = Core.getInstance().getClipboard().getItemsByClass(this.clazz);
        block0: for (ClipboardItem item : clipboardItems) {
            for (ClipboardItem yetAdded : items) {
                if (item.getUserData() != yetAdded.getUserData()) continue;
                continue block0;
            }
            items.add(item);
        }
        return items;
    }

    private List<ClipboardItem> listClipboardTransformables() {
        ArrayList<ClipboardItem> items = new ArrayList<ClipboardItem>();
        List transformers = Core.getInstance().getTransformersByDestiny(this.clazz);
        List clipboardItems = Core.getInstance().getClipboard().getAllItems();
        block0: for (ClipboardItem item : clipboardItems) {
            for (ClipboardItem yetAdded : items) {
                if (yetAdded != items) continue;
                continue block0;
            }
            for (Transformer t : transformers) {
                if (item.getUserData() == null || !t.getSourceType().isAssignableFrom(item.getUserData().getClass())) continue;
                items.add(item);
                continue block0;
            }
        }
        return items;
    }

    private synchronized void reloadComponent() {
        List<ClipboardItem> listItems = this.listClibpoardItems();
        List<ClipboardItem> listTransformables = this.listClipboardTransformables();
        listTransformables.removeAll(listItems);
        this.countItemsInClipboard = listItems.size() + listTransformables.size();
        String lastText = this.getCurrentString();
        if (!this.hasStringConstructor || this.countItemsInClipboard > 0 || this.port.allowNull()) {
            Object lastItem;
            boolean valueSetted = false;
            if (this.isShowingCombo()) {
                lastItem = this.combo.getSelectedIndex() == -1 ? null : this.combo.getSelectedItem();
            } else {
                lastItem = null;
                if (this.textField != null) {
                    this.panel.remove(this.textField);
                    this.textField.removeFocusListener(FOCUS_LISTENER);
                    this.textField.removeActionListener(this);
                    this.textField.removeKeyListener(this);
                    this.textField = null;
                }
                this.combo = new JComboBox();
                this.combo.addActionListener(this);
                this.combo.addFocusListener(FOCUS_LISTENER);
            }
            this.combo.removeAllItems();
            if (this.hasStringConstructor) {
                this.combo.setEditable(true);
                this.combo.addKeyListener(this);
            } else {
                this.combo.setEditable(false);
                this.combo.removeKeyListener(this);
            }
            int itemindex = 0;
            if (listItems != null) {
                for (ClipboardItem item : listItems) {
                    this.combo.addItem(item);
                    if (lastItem != null && item == lastItem) {
                        this.combo.setSelectedIndex(itemindex);
                        valueSetted = true;
                    }
                    ++itemindex;
                    if (this.combo.isEditable() && lastText != null && lastText.length() != 0 || ParamsWindow.preferredClipboardItem == null || ParamsWindow.preferredClipboardItem != item) continue;
                    this.combo.setSelectedItem(item);
                    valueSetted = true;
                }
            }
            if (this.combo.isEditable() && !valueSetted) {
                if (lastText != null && lastText.length() > 0) {
                    this.combo.setSelectedItem(lastText);
                    valueSetted = true;
                } else if (!this.port.defaultValue().equals("")) {
                    this.combo.setSelectedItem(this.port.defaultValue());
                    valueSetted = true;
                }
            }
            List transformers = Core.getInstance().getTransformersByDestiny(this.clazz);
            for (ClipboardItem item : listTransformables) {
                for (Transformer t : transformers) {
                    if (item.getUserData() == null || !t.getSourceType().isAssignableFrom(item.getUserData().getClass())) continue;
                    TransformerClipboardItem tci = new TransformerClipboardItem(item, t);
                    this.combo.addItem(tci);
                    if (ParamsWindow.preferredClipboardItem == null || ParamsWindow.preferredClipboardItem != item) continue;
                    this.combo.setSelectedItem(tci);
                }
            }
            if (this.port.allowNull()) {
                this.combo.addItem(new NullItem());
                if (!valueSetted && this.port.defaultValue().equalsIgnoreCase("null")) {
                    this.combo.setSelectedIndex(this.combo.getItemCount() - 1);
                }
            }
        } else {
            if (this.textField == null) {
                if (this.combo != null) {
                    this.panel.remove(this.combo);
                    this.combo.removeActionListener(this);
                    this.combo.removeKeyListener(this);
                    this.combo.removeFocusListener(FOCUS_LISTENER);
                    this.combo = null;
                }
                this.textField = new JTextField();
                this.textField.addActionListener(this);
                this.textField.addKeyListener(this);
                this.textField.addFocusListener(FOCUS_LISTENER);
            }
            if (lastText == null || lastText.equals("")) {
                this.textField.setText(this.port.defaultValue());
            } else {
                this.textField.setText(lastText);
            }
        }
        this.adjustComponentWidth();
        this.addComponentToPanel();
        if (this.listener == null) {
            this.listener = new ClipboardParamListener();
            Core.getInstance().getClipboard().addClipboardListener((ClipboardListener)this.listener);
        }
    }

    private void addComponentToPanel() {
        if (this.combo != null) {
            this.panel.add(this.combo, "Center");
        } else if (this.textField != null) {
            this.panel.add((Component)this.textField, "Center");
        }
    }

    private void adjustComponentWidth() {
        JComponent component = this.getCurrentComponent();
        if (component != null) {
            if (component.getPreferredSize().width < 50) {
                component.setPreferredSize(new Dimension(100, component.getPreferredSize().height));
            }
            if (component.getPreferredSize().width > 500) {
                component.setPreferredSize(new Dimension(500, component.getPreferredSize().height));
            }
        }
    }

    @Override
    public void finish() {
        if (this.listener != null) {
            Core.getInstance().getClipboard().removeClipboardListener((ClipboardListener)this.listener);
        }
    }

    synchronized ParamSpec[] listParamSpecs() {
        if (this.isShowingCombo() && this.combo.getItemCount() > 0) {
            ArrayList<ParamSpec> params = new ArrayList<ParamSpec>(this.combo.getItemCount());
            for (int i = 0; i < this.combo.getItemCount(); ++i) {
                Object item = this.combo.getItemAt(i);
                if (item == null || item instanceof NullItem) continue;
                if (item instanceof TransformerClipboardItem) {
                    ParamSpec transformerParam = new ParamSpec(this.port.name(), this.clazz, (Object)((TransformerClipboardItem)item).item, ParamSource.CLIPBOARD);
                    transformerParam.setTransformerSignature(((TransformerClipboardItem)item).transformer.getSignature());
                    params.add(transformerParam);
                    continue;
                }
                params.add(new ParamSpec(this.port.name(), this.clazz, item, ParamSource.CLIPBOARD));
            }
            return params.toArray(new ParamSpec[params.size()]);
        }
        if (this.isShowingTextField()) {
            return new ParamSpec[]{new ParamSpec(this.port.name(), this.clazz, (Object)this.textField.getText(), ParamSource.STRING_CONSTRUCTOR)};
        }
        return new ParamSpec[0];
    }

    @Override
    public synchronized ParamSpec getParamSpec() {
        if (this.isShowingCombo()) {
            if (this.combo.isEditable() && this.combo.getSelectedIndex() == -1) {
                if (this.combo.getSelectedItem() == null) {
                    return new ParamSpec(this.port.name(), this.clazz, (Object)"", ParamSource.STRING_CONSTRUCTOR);
                }
                return new ParamSpec(this.port.name(), this.clazz, (Object)this.combo.getSelectedItem().toString(), ParamSource.STRING_CONSTRUCTOR);
            }
            if (this.combo.getSelectedItem() instanceof TransformerClipboardItem) {
                ParamSpec toret = new ParamSpec(this.port.name(), this.clazz, (Object)((TransformerClipboardItem)this.combo.getSelectedItem()).item, ParamSource.CLIPBOARD);
                toret.setTransformerSignature(((TransformerClipboardItem)this.combo.getSelectedItem()).transformer.getSignature());
                return toret;
            }
            if (this.combo.getSelectedItem() instanceof NullItem) {
                return new ParamSpec(this.port.name(), this.clazz, null, ParamSource.CLIPBOARD);
            }
            return new ParamSpec(this.port.name(), this.clazz, this.combo.getSelectedItem(), ParamSource.CLIPBOARD);
        }
        if (this.isShowingTextField()) {
            return new ParamSpec(this.port.name(), this.clazz, (Object)this.textField.getText(), ParamSource.STRING_CONSTRUCTOR);
        }
        return new ParamSpec(this.port.name(), this.clazz, (Object)"", ParamSource.STRING_CONSTRUCTOR);
    }

    protected boolean classHasOperations(Class<?> klazz) {
        for (OperationWrapper wrapper : Workbench.getInstance().getInterceptedOperations()) {
            for (Object outcomingType : wrapper.getOperationDefinition().getOutcomingArgumentTypes()) {
                Class clazz = (Class)outcomingType;
                if (klazz.isAssignableFrom(clazz)) {
                    return true;
                }
                for (Transformer t : Core.getInstance().getTransformersBySource(clazz)) {
                    if (!klazz.isAssignableFrom(t.getDestinyType())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected JMenu getOperationsWhichGeneratesPopup(Class<?> klazz) {
        HashMap<OperationWrapper, Integer> added = new HashMap<OperationWrapper, Integer>();
        JMenu popup = new JMenu();
        for (OperationWrapper wrapper : Workbench.getInstance().getInterceptedOperations()) {
            WaitOperationWrapper waitWrapper = new WaitOperationWrapper(wrapper.getOperationDefinition(), new OperationResultsCollector(){

                @Override
                public void resultsGetted(List<ClipboardItem> results) {
                    if (results != null) {
                        for (ClipboardItem item : results) {
                            Workbench.getInstance().getTreeManager().elementRemoved(item);
                        }
                        ClipboardParamProvider.this.getReceiver().removeAfterTermination(results);
                    }
                }
            });
            for (Object outcomingType : wrapper.getOperationDefinition().getOutcomingArgumentTypes()) {
                Class clazz = (Class)outcomingType;
                if (klazz.isAssignableFrom(clazz)) {
                    if (added.get(wrapper) != null) continue;
                    if (Workbench.getInstance().isOperationViewableIn(wrapper.getOperationDefinition(), "DIALOG")) {
                        added.put(wrapper, 0);
                        Utilities.putOperationInMenu(popup, waitWrapper);
                    }
                }
                List transformers = Core.getInstance().getTransformersBySource(clazz);
                for (Transformer t : transformers) {
                    if (!klazz.isAssignableFrom(t.getDestinyType()) || !Workbench.getInstance().isOperationViewableIn(wrapper.getOperationDefinition(), "DIALOG")) continue;
                    Utilities.putOperationInMenu(popup, waitWrapper);
                }
            }
        }
        if (popup.getItemCount() == 0) {
            return null;
        }
        popup.setIcon(ICON_OPERATIONS);
        popup.setToolTipText("Create parameter with an operation.");
        return popup;
    }

    public boolean isShowCreateButton() {
        return this.showCreateButton;
    }

    public void setShowCreateButton(boolean showCreateButton) {
        this.showCreateButton = showCreateButton;
        if (showCreateButton) {
            this.panel.add((Component)this.createButton, "East");
        } else {
            this.panel.remove(this.createButton);
        }
    }

    @Override
    public synchronized boolean isValidValue() {
        if (!this.port.allowNull()) {
            if (this.combo != null) {
                return this.combo.getSelectedItem() != null;
            }
            if (this.textField != null) {
                return this.isValidTextFieldValue();
            }
        }
        return true;
    }

    private boolean isValidTextFieldValue() {
        return this.allowTextFieldEmptyString || !this.textField.getText().isEmpty();
    }

    protected class TransformerClipboardItem {
        ClipboardItem item;
        Transformer transformer;

        TransformerClipboardItem(ClipboardItem item, Transformer t) {
            this.item = item;
            this.transformer = t;
        }

        public String toString() {
            if (Boolean.valueOf(Workbench.CONFIG.getProperty("inputdialog.providers.clipboard.showtransformername", "true")).booleanValue()) {
                return this.item.toString() + " (" + this.transformer.getName() + ")";
            }
            return this.item.toString();
        }
    }

    protected class NullItem {
        protected NullItem() {
        }

        public String toString() {
            return ClipboardParamProvider.this.nullItemText;
        }
    }

    private class ClipboardParamListener
    implements ClipboardListener {
        private ClipboardParamListener() {
        }

        public void elementAdded(ClipboardItem item) {
            ClipboardParamProvider.this.reloadComponent();
        }

        public void elementRemoved(ClipboardItem item) {
            ClipboardParamProvider.this.reloadComponent();
        }
    }
}

