/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench;

import es.uvigo.ei.aibench.Util;
import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.core.operation.OperationDefinition;
import es.uvigo.ei.aibench.core.operation.annotation.Cancel;
import es.uvigo.ei.aibench.core.operation.annotation.Progress;
import es.uvigo.ei.aibench.core.operation.annotation.ProgressProperty;
import es.uvigo.ei.aibench.workbench.Workbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class MonitorizeDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final String WORKING_PROGRESS_ICON = "progress.workingicon";
    private static final Logger LOGGER = Logger.getLogger(MonitorizeDialog.class);
    private static final int REFRESH_MILLIS = 10;
    private Object bean;
    private Object operationID;
    private OperationDefinition<?> definition;
    private boolean finish = false;
    private PropertyDescriptor[] descriptors;
    private HashMap<PropertyDescriptor, RenderComponent> mapping = new HashMap();
    private Timer t = null;
    private JPanel contentPane;

    public MonitorizeDialog(JFrame parent) {
        this(parent, (Object)null, (Object)null, null);
    }

    public MonitorizeDialog(JFrame parent, Object bean, Object operationID, OperationDefinition<?> definition) {
        super(parent);
        this.bean = bean;
        this.operationID = operationID;
        this.definition = definition;
        this.initialize();
    }

    private void initialize() {
        this.setModal(this.getIsModal());
        this.setTitle(this.getDialogTitle());
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getDialogContentPane());
        this.pack();
        this.setPreferredSize();
        this.centerOnOwner();
        this.setResizable(false);
    }

    private void setPreferredSize() {
        int preferredWidth = this.getPreferredWidth();
        int preferredHeight = this.getPreferredHeight();
        if (preferredHeight != Integer.MIN_VALUE && preferredWidth != Integer.MIN_VALUE) {
            this.setPreferredSize(new Dimension(preferredWidth, preferredHeight));
        }
    }

    private int getPreferredWidth() {
        if (this.getProgress() != null) {
            return this.getProgress().preferredWidth();
        }
        return Integer.MIN_VALUE;
    }

    private int getPreferredHeight() {
        if (this.getProgress() != null) {
            return this.getProgress().preferredHeight();
        }
        return Integer.MIN_VALUE;
    }

    private Container getDialogContentPane() {
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.contentPane.setBackground(Color.WHITE);
        this.contentPane.add((Component)this.getWorkingPanel(), "North");
        this.addBeanProgressPropertiesPanel();
        this.addCancelButtonPanel();
        return this.contentPane;
    }

    private JPanel getWorkingPanel() {
        JPanel workingPanel = new JPanel(new GridBagLayout());
        workingPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        workingPanel.setBackground(Color.WHITE);
        JLabel working = new JLabel(this.getWorkingLabelText());
        working.setOpaque(false);
        working.setBackground(Color.WHITE);
        working.setAlignmentY(0.5f);
        working.setIcon(this.getProgressIcon());
        workingPanel.add(working);
        return workingPanel;
    }

    private Icon getProgressIcon() {
        String iconFile = Workbench.CONFIG.getProperty(WORKING_PROGRESS_ICON);
        if (iconFile != null) {
            URL imageURL = Util.getGlobalResourceURL((String)iconFile);
            return new ImageIcon(imageURL);
        }
        return new ImageIcon(this.getClass().getResource("/images/longtask.gif"));
    }

    private boolean getIsModal() {
        return this.getProgress() == null ? false : this.getProgress().modal();
    }

    private String getDialogTitle() {
        return this.getProgress() == null ? "Progress..." : this.getProgress().progressDialogTitle();
    }

    private Progress getProgress() {
        if (this.definition.getMonitorBeanMethod() != null) {
            return this.definition.getMonitorBeanMethod().getAnnotation(Progress.class);
        }
        return null;
    }

    private String getWorkingLabelText() {
        return this.getProgress() == null ? "Working" : this.getProgress().workingLabel();
    }

    private void addBeanProgressPropertiesPanel() {
        if (this.bean == null) {
            return;
        }
        try {
            JPanel beanInfoPanel = new JPanel();
            beanInfoPanel.setBackground(Color.WHITE);
            beanInfoPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            beanInfoPanel.setLayout(new GridLayout(2, 2));
            GridBagLayout newLayout = new GridBagLayout();
            beanInfoPanel.setLayout(newLayout);
            BeanInfo info = Introspector.getBeanInfo(this.bean.getClass());
            this.descriptors = this.getPropertyDescriptors(info);
            int i = 0;
            for (PropertyDescriptor descriptor : this.descriptors) {
                GridBagConstraints c = new GridBagConstraints();
                JLabel label = new JLabel(this.getDescriptorName(descriptor));
                c.fill = 2;
                c.gridx = 0;
                c.gridy = ++i;
                c.weightx = 0.0;
                c.anchor = 17;
                c.insets = new Insets(5, 5, 5, 5);
                newLayout.setConstraints(label, c);
                beanInfoPanel.add(label);
                JComponent component = null;
                component = descriptor.getPropertyType().equals(Float.TYPE) || descriptor.getPropertyType().equals(Float.class) ? new JProgressBarRenderer(this.getDescriptorStringPainted(descriptor)) : new JLabelRenderer();
                this.mapping.put(descriptor, (RenderComponent)((Object)component));
                c.gridx = 1;
                c.weightx = 1.0;
                newLayout.setConstraints(component, c);
                beanInfoPanel.add(component);
            }
            this.contentPane.add((Component)beanInfoPanel, "Center");
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        Thread dummy = new Thread(){

            @Override
            public void run() {
                while (!MonitorizeDialog.this.finish) {
                    try {
                        1.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    MonitorizeDialog.this.update();
                }
            }
        };
        dummy.setPriority(10);
        dummy.start();
    }

    protected PropertyDescriptor[] getPropertyDescriptors(BeanInfo info) {
        LinkedList<PropertyDescriptor> descriptors = new LinkedList<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
            if (descriptor.getName().equals("class")) continue;
            if (descriptor.getReadMethod() != null) {
                ProgressProperty progressProperty = descriptor.getReadMethod().getAnnotation(ProgressProperty.class);
                if (progressProperty != null && progressProperty.ignore()) continue;
                descriptors.add(descriptor);
                if (descriptor.getWriteMethod() != null) continue;
                LOGGER.warn((Object)("Warning: progress bean property " + descriptor.getName() + " does not have a write method associated so it probably can't be updated"));
                continue;
            }
            LOGGER.warn((Object)("Ignoring progress bean property " + descriptor.getName() + " since it does not have a read method associated"));
        }
        return this.orderDescriptors(descriptors);
    }

    private PropertyDescriptor[] orderDescriptors(List<PropertyDescriptor> propertyDescriptors) {
        if (this.getProgress() == null) {
            return propertyDescriptors.toArray(new PropertyDescriptor[propertyDescriptors.size()]);
        }
        HashMap descriptorsOrder = new HashMap();
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            ProgressProperty descriptorProperty = descriptor.getReadMethod().getAnnotation(ProgressProperty.class);
            int order = descriptorProperty == null ? 0 : descriptorProperty.order();
            if (!descriptorsOrder.containsKey(order)) {
                descriptorsOrder.put(order, new LinkedList());
            }
            ((List)descriptorsOrder.get(order)).add(descriptor);
        }
        LinkedList order = new LinkedList(descriptorsOrder.keySet());
        Collections.sort(order);
        LinkedList orderedDescriptors = new LinkedList();
        for (Integer o : order) {
            orderedDescriptors.addAll((Collection)descriptorsOrder.get(o));
            if (((List)descriptorsOrder.get(o)).size() <= 1) continue;
            LOGGER.warn((Object)("Several progress properties at the same position (" + o + "). Thay may appear in a random order."));
        }
        return orderedDescriptors.toArray(new PropertyDescriptor[orderedDescriptors.size()]);
    }

    private String getDescriptorName(PropertyDescriptor descriptor) {
        ProgressProperty descriptorProperty = descriptor.getReadMethod().getAnnotation(ProgressProperty.class);
        if (descriptorProperty != null) {
            if (descriptorProperty.label().equals("")) {
                return descriptor.getName();
            }
            return descriptorProperty.label();
        }
        return descriptor.getName();
    }

    private boolean getDescriptorStringPainted(PropertyDescriptor descriptor) {
        ProgressProperty descriptorProperty = descriptor.getReadMethod().getAnnotation(ProgressProperty.class);
        return descriptorProperty.showProgressBarLabel();
    }

    private void addCancelButtonPanel() {
        if (this.definition.getCancelMethod() != null) {
            Cancel cancel = this.definition.getCancelMethod().getAnnotation(Cancel.class);
            final JButton stopButton = new JButton(cancel.cancelButtonLabel());
            stopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Core.getInstance().cancelOperation(MonitorizeDialog.this.operationID);
                }
            });
            this.contentPane.add((Component)new JPanel(){
                private static final long serialVersionUID = 1L;
                {
                    this.setBackground(Color.WHITE);
                    this.add(stopButton);
                }
            }, "South");
        }
    }

    private void update() {
        for (PropertyDescriptor descriptor : this.descriptors) {
            try {
                Method readMethod = descriptor.getReadMethod();
                if (readMethod == null || this.mapping.get(descriptor) == null) continue;
                this.mapping.get(descriptor).updateValue(readMethod.invoke(this.bean, new Object[0]));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.pack();
    }

    private void centerOnOwner() {
        Rectangle rectOwner = this.getParent().getBounds();
        Rectangle rectDialog = this.getBounds();
        this.setLocation(rectOwner.x + rectOwner.width / 2 - rectDialog.width / 2, rectOwner.y + rectOwner.height / 2 - rectDialog.height / 2);
    }

    @Override
    public void setVisible(boolean flag) {
        if (!flag && this.t != null) {
            this.t.stop();
        }
        super.setVisible(flag);
    }

    public void setFinish(boolean finish) {
        this.finish = finish;
    }

    private class JLabelRenderer
    extends JLabel
    implements RenderComponent {
        private static final long serialVersionUID = 1L;

        JLabelRenderer() {
            super("");
        }

        @Override
        public void updateValue(Object value) {
            if (value == null) {
                return;
            }
            this.setText(value.toString());
        }
    }

    private class JProgressBarRenderer
    extends JProgressBar
    implements RenderComponent {
        private static final long serialVersionUID = 1L;

        JProgressBarRenderer(boolean stringPainted) {
            this.setMaximum(100);
            this.setValue(0);
            this.setStringPainted(stringPainted);
        }

        @Override
        public void updateValue(Object value) {
            if (value instanceof Float) {
                if (((Float)value).floatValue() < 0.0f) {
                    this.setValue(0);
                    this.setIndeterminate(true);
                } else {
                    this.setIndeterminate(false);
                    this.setValue((int)(((Float)value).floatValue() * 100.0f));
                }
            }
        }
    }

    static interface RenderComponent {
        public void updateValue(Object var1);
    }
}

