/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.jsparklines_factory.builders.barchartrenderer;

import java.awt.Color;
import javax.swing.JTable;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;
import org.sing_group.jsparklines_factory.JSparklinesBarChartTableCellRendererFactory;
import org.sing_group.jsparklines_factory.util.TableUtils;

public class MaximumMinimumColoredBarChartRendererBuilder {
    private JTable table;
    private int column;
    private PlotOrientation plotOrientation = JSparklinesBarChartTableCellRendererFactory.DEFAULT_ORIENTATION;
    private Double maxValue;
    private Double minValue;
    private Color positiveValuesColor = JSparklinesBarChartTableCellRendererFactory.DEFAULT_POSITIVES_COLOR;
    private Color negativeValuesColor = JSparklinesBarChartTableCellRendererFactory.DEFAULT_NEGATIVES_COLOR;

    public MaximumMinimumColoredBarChartRendererBuilder(JTable table, int column) {
        this.table = table;
        this.column = column;
    }

    public MaximumMinimumColoredBarChartRendererBuilder withPlotOrientation(PlotOrientation plotOrientation) {
        this.plotOrientation = plotOrientation;
        return this;
    }

    public MaximumMinimumColoredBarChartRendererBuilder withMaxValue(Double maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public MaximumMinimumColoredBarChartRendererBuilder withPositiveValuesColor(Color positiveValuesColor) {
        this.positiveValuesColor = positiveValuesColor;
        return this;
    }

    public MaximumMinimumColoredBarChartRendererBuilder withMinValue(Double minValue) {
        this.minValue = minValue;
        return this;
    }

    public MaximumMinimumColoredBarChartRendererBuilder withNegativeValuesColor(Color negativeValuesColor) {
        this.negativeValuesColor = negativeValuesColor;
        return this;
    }

    public JSparklinesBarChartTableCellRenderer build() {
        this.checkMaxMinValues();
        return JSparklinesBarChartTableCellRendererFactory.createMaxMinValuesColoredBarChartRenderer(this.table, this.column, this.plotOrientation, this.maxValue, this.positiveValuesColor, this.minValue, this.negativeValuesColor);
    }

    private void checkMaxMinValues() {
        if (this.maxValue == null) {
            this.maxValue = TableUtils.getMaxColumnValue(this.table, this.column);
        }
        if (this.minValue == null) {
            this.minValue = TableUtils.getMinColumnValue(this.table, this.column);
        }
    }
}

