/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.wizard;

import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.sing_group.gc4s.wizard.event.WizardStepEvent;
import org.sing_group.gc4s.wizard.event.WizardStepListener;

public abstract class WizardStep {
    private final List<WizardStepListener> listeners = new LinkedList<WizardStepListener>();

    public abstract String getStepTitle();

    public abstract JComponent getStepComponent();

    public abstract boolean isStepCompleted();

    public abstract void stepEntered();

    public void addWizardStepListener(WizardStepListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeWizardStepListener(WizardStepListener listener) {
        return this.listeners.remove(listener);
    }

    public List<WizardStepListener> getWizardStepListeners() {
        return this.listeners;
    }

    protected void notifyWizardStepStatus() {
        WizardStepEvent event = new WizardStepEvent(this);
        if (this.isStepCompleted()) {
            this.notifyWizardStepCompleted(event);
        } else {
            this.notifyWizardStepUncompleted(event);
        }
    }

    protected void notifyWizardStepCompleted(WizardStepEvent event) {
        this.getWizardStepListeners().forEach(l -> l.wizardStepCompleted(event));
    }

    protected void notifyWizardStepUncompleted(WizardStepEvent event) {
        this.getWizardStepListeners().forEach(l -> l.wizardStepUncompleted(event));
    }
}

