/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.hlfernandez.visualization;

import es.uvigo.ei.sing.hlfernandez.utilities.MatrixUtils;
import java.util.function.BiFunction;
import java.util.function.Function;

public class JHeatMapOperations {
    public static double[][] center(double[][] matrix, Centering centering, boolean excludeNan) {
        return MatrixUtils.center(matrix, centering.getFunction(), excludeNan);
    }

    public static double[][] transform(double[][] matrix, Transform transform) {
        return MatrixUtils.transform(matrix, transform.getFunction());
    }

    public static enum Centering {
        MEAN("Mean", MatrixUtils::mean),
        MEDIAN("Median", MatrixUtils::median),
        NONE("None", (a, b) -> 0.0);

        private BiFunction<double[], Boolean, Double> function;
        private String name;

        private Centering(String name, BiFunction<double[], Boolean, Double> function) {
            this.name = name;
            this.function = function;
        }

        public String getName() {
            return this.name;
        }

        public BiFunction<double[], Boolean, Double> getFunction() {
            return this.function;
        }
    }

    public static enum Transform {
        LOG2("Log 2", Math::log),
        NONE("None", e -> e);

        private String name;
        private Function<Double, Double> function;

        private Transform(String name, Function<Double, Double> function) {
            this.name = name;
            this.function = function;
        }

        public String getName() {
            return this.name;
        }

        public Function<Double, Double> getFunction() {
            return this.function;
        }
    }
}

