/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench;

import es.uvigo.ei.aibench.AIBenchLogger;
import es.uvigo.ei.aibench.Paths;
import es.uvigo.ei.aibench.SplashFrame;
import es.uvigo.ei.aibench.Util;
import es.uvigo.ei.aibench.repository.PluginInstaller;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.platonos.pluginengine.Extension;
import org.platonos.pluginengine.ExtensionPoint;
import org.platonos.pluginengine.Plugin;
import org.platonos.pluginengine.PluginEngine;
import org.platonos.pluginengine.PluginFileConfiguration;
import org.platonos.pluginengine.logging.ILogger;

public class Launcher {
    private static Logger logger = Logger.getLogger(Launcher.class);
    public static Properties CONFIG = new Properties();
    public static String pluginsDir;
    public static PluginEngine pluginEngine;

    public static PluginEngine getPluginEngine() {
        if (pluginEngine == null) {
            PluginFileConfiguration configuration = null;
            try {
                configuration = new PluginFileConfiguration(Util.getGlobalResourceURL(Paths.getInstance().getPluginsConfigurationPath()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (Boolean.parseBoolean(CONFIG.getProperty("pluginengine.debug"))) {
                pluginEngine = new PluginEngine("AIBench Engine", configuration);
            } else {
                AIBenchLogger ilog = new AIBenchLogger();
                pluginEngine = new PluginEngine("AIBench Engine", configuration, (ILogger)ilog);
            }
        }
        return pluginEngine;
    }

    public static List<Object> getExtensionPointInstances(String pluginID, String extensionPoint) {
        Plugin plugin = Launcher.getPluginEngine().getPlugin(pluginID);
        ExtensionPoint extPoint = plugin.getExtensionPoint(extensionPoint);
        ArrayList<Object> toret = new ArrayList<Object>();
        if (extPoint != null) {
            for (Extension extension : extPoint.getExtensions()) {
                toret.add(extension.getExtensionInstance());
            }
        }
        return toret;
    }

    private static void installUpdates() {
        if (Boolean.parseBoolean(CONFIG.getProperty("startup.install_plugins", "false"))) {
            Properties properties = new Properties();
            try {
                properties.load(Util.getGlobalResourceURL(Paths.getInstance().getPluginManagerConfigurationPath()).openStream());
                String installerDir = properties.getProperty("plugininstaller.dir");
                if (installerDir == null) {
                    System.err.println("Installer directory property ('plugininstaller.dir') isn't set at file 'conf/pluginmanager.conf'.");
                } else {
                    Boolean deleteInvalidInstalls = Boolean.parseBoolean(properties.getProperty("plugininstaller.delete_invalid_installs", "true"));
                    String ignoreDirs = properties.getProperty("plugininstaller.ignore_dirs");
                    PluginInstaller installer = ignoreDirs != null && ignoreDirs.trim().length() > 0 ? new PluginInstaller(pluginsDir, installerDir, ignoreDirs.trim().split(";")) : new PluginInstaller(pluginsDir, installerDir);
                    installer.installPlugins(deleteInvalidInstalls);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void configure() {
        URL url = Util.getGlobalResourceURL(Paths.getInstance().getLog4jConfigurationPath());
        PropertyConfigurator.configure(url);
    }

    public static void main(String[] args) {
        Launcher.readConfig();
        pluginsDir = args.length >= 1 ? args[0] : "plugins_bin";
        SplashFrame splash = null;
        if (System.getProperty("aibench.nogui") == null) {
            splash = new SplashFrame();
            splash.setVisible(true);
        }
        Launcher.configure();
        Launcher.installUpdates();
        PluginEngine engine = Launcher.getPluginEngine();
        if (System.getProperty("aibench.nogui") == null) {
            engine.addPluginEngineListener(splash);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info("Shutting down plugin engine");
                Launcher.getPluginEngine().shutdown();
            }
        });
        engine.setStartPluginThreadCount(1);
        engine.loadPlugins(pluginsDir);
        logger.info("Plugins loaded");
        engine.start();
    }

    private static void readConfig() {
        try {
            CONFIG.load(Util.getGlobalResourceURL(Paths.getInstance().getAibenchConfigurationPath()).openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Launcher() {
    }
}

