/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.DataUtil;
import com.googlecode.charts4j.collect.Lists;
import com.googlecode.charts4j.collect.Preconditions;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Data {
    public static final double MIN_VALUE = 0.0;
    public static final double MAX_VALUE = 100.0;
    public static final Data INVALID = Data.newData(-1.0);
    private final double[] data;

    public Data(double ... data) {
        Preconditions.checkNotNull(data, "data is null or contents of data is null.");
        this.data = (double[])data.clone();
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    public final double[] getData() {
        return (double[])this.data.clone();
    }

    public final int getSize() {
        return this.data.length;
    }

    public static Data newData(double ... data) {
        return new Data(data);
    }

    public static Data newData(List<? extends Number> data) {
        Preconditions.checkContentsNotNull(data, "data is null or contents of data is null.");
        return new Data(DataUtil.toDoubleArray(Lists.copyOf(data)));
    }
}

