/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.operation;

import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.core.operation.annotation.Cancel;
import es.uvigo.ei.aibench.core.operation.annotation.Direction;
import es.uvigo.ei.aibench.core.operation.annotation.Operation;
import es.uvigo.ei.aibench.core.operation.annotation.Port;
import es.uvigo.ei.aibench.core.operation.annotation.Progress;
import es.uvigo.ei.aibench.core.operation.execution.EndpointsFactory;
import es.uvigo.ei.aibench.core.operation.execution.Executable;
import es.uvigo.ei.aibench.core.operation.execution.StandardExecutable;
import es.uvigo.ei.pipespecification.InvalidAnnotationsException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import org.w3c.dom.Element;

public class OperationDefinition<T> {
    private String name = "";
    private String id = "";
    private String description = "";
    private String help = "";
    private String pluginName = "";
    private String pluginID = "";
    private String shortcut = "";
    private String path = "";
    private String menuName = "";
    private boolean enabledByDefault;
    private List<EndpointsFactory<T>> factories;
    private List<Class<?>> outcomingArgumentTypes;
    private List<Class<?>> incomingArgumentTypes;
    private Port[] ports;
    private Method monitorBeanMethod;
    private Method cancelMethod;

    protected OperationDefinition() {
    }

    public String getPluginID() {
        return this.pluginID;
    }

    public void setPluginID(String pluginID) {
        this.pluginID = pluginID;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(String shortcut) {
        this.shortcut = shortcut;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getMenuName() {
        return this.menuName.isEmpty() ? this.name : this.menuName;
    }

    public void setMenuName(String menuName) {
        this.menuName = menuName;
    }

    public boolean isEnabled() {
        return Core.getInstance().isOperationEnabled(this);
    }

    public boolean isEnabled(Core instance) {
        return instance.isOperationEnabled(this);
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public static <T> OperationDefinition<T> createOperationDefinition(Class<T> annotatedClass) throws InvalidAnnotationsException {
        Operation pipeElement = annotatedClass.getAnnotation(Operation.class);
        if (pipeElement == null) {
            throw new IllegalArgumentException("the class (" + annotatedClass.getName() + ") must be annotated with " + Operation.class.getName());
        }
        ArrayList<Port> portsList = new ArrayList<Port>();
        ArrayList<Method> methodList = new ArrayList<Method>();
        Method progressMethod = null;
        Method cancelMethod = null;
        Method[] methods = annotatedClass.getMethods();
        OperationDefinition.sortByPorts(methods);
        for (Method method : methods) {
            Cancel cancel;
            Progress progress;
            Port port = method.getAnnotation(Port.class);
            if (port != null) {
                methodList.add(method);
                portsList.add(port);
            }
            if ((progress = method.getAnnotation(Progress.class)) != null) {
                progressMethod = method;
            }
            if ((cancel = method.getAnnotation(Cancel.class)) == null) continue;
            cancelMethod = method;
        }
        Port[] ports = new Port[portsList.size()];
        int j = 0;
        for (Port port : portsList) {
            ports[j++] = port;
        }
        ArrayList<EndpointsFactory<T>> factories = new ArrayList<EndpointsFactory<T>>();
        for (int i = 0; i < ports.length; ++i) {
            factories.add(EndpointsFactory.createEndpointsFactory(annotatedClass, ports[i], ((Method)methodList.get(i)).getParameterTypes(), ((Method)methodList.get(i)).getName()));
        }
        OperationDefinition<T> toret = new OperationDefinition<T>(annotatedClass, Collections.unmodifiableList(factories), ports, pipeElement.name(), pipeElement.description(), pipeElement.help());
        toret.enabledByDefault = pipeElement.enabled();
        toret.setMonitorBeanMethod(progressMethod);
        toret.setCancelMethod(cancelMethod);
        return toret;
    }

    private static void sortByPorts(Method[] methods) {
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                Port o1Port = o1.getAnnotation(Port.class);
                Port o2Port = o2.getAnnotation(Port.class);
                if (o1Port == null) {
                    return -1;
                }
                if (o2Port == null) {
                    return 1;
                }
                int toret = new Integer(o1Port.order()).compareTo(o2Port.order());
                if (toret == 0) {
                    if (o1Port.direction() == o2Port.direction()) {
                        return 0;
                    }
                    return o1Port.direction() == Direction.INPUT ? -1 : 1;
                }
                return toret;
            }
        });
    }

    public static <T> OperationDefinition<T> createOperationDefinition(Class<T> annotatedClass, List<Element> ports) {
        ArrayList<EndpointsFactory<T>> factoriesList = new ArrayList<EndpointsFactory<T>>();
        for (Element port : ports) {
            factoriesList.add(EndpointsFactory.createEndPointsFactory(annotatedClass, port));
        }
        return new OperationDefinition<T>(annotatedClass, Collections.unmodifiableList(factoriesList), null, annotatedClass.getAnnotation(Operation.class).name(), annotatedClass.getAnnotation(Operation.class).description(), annotatedClass.getAnnotation(Operation.class).help());
    }

    private OperationDefinition(Class<T> annotatedClass, List<EndpointsFactory<T>> factories, Port[] ports, String name, String description, String help) throws InvalidAnnotationsException {
        this.name = name;
        this.description = description;
        this.help = help;
        this.factories = factories;
        ArrayList outcomingTypes = new ArrayList();
        ArrayList incomingTypes = new ArrayList();
        for (EndpointsFactory<T> factory : this.factories) {
            factory.addArguments(incomingTypes, outcomingTypes);
        }
        this.outcomingArgumentTypes = outcomingTypes;
        this.incomingArgumentTypes = incomingTypes;
        this.ports = ports;
    }

    public Executable makeExecutable(T instance, ExecutorService executor, Object ... values) {
        return new StandardExecutable<T>(this.factories, this.incomingArgumentTypes, this.outcomingArgumentTypes, executor, instance, values);
    }

    public List<Class<?>> getIncomingArgumentTypes() {
        return this.incomingArgumentTypes;
    }

    public List<Class<?>> getOutcomingArgumentTypes() {
        return this.outcomingArgumentTypes;
    }

    public List<Port> getPorts() {
        Vector<Port> v = new Vector<Port>();
        for (Port p : this.ports) {
            v.add(p);
        }
        return v;
    }

    public Method getMonitorBeanMethod() {
        return this.monitorBeanMethod;
    }

    public void setMonitorBeanMethod(Method method) {
        this.monitorBeanMethod = method;
    }

    public Method getCancelMethod() {
        return this.cancelMethod;
    }

    public void setCancelMethod(Method cancelMethod) {
        this.cancelMethod = cancelMethod;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

