/*
 * Decompiled with CFR 0.152.
 */
package org.platonos.pluginengine;

import es.uvigo.ei.aibench.Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.platonos.pluginengine.Dependency;
import org.platonos.pluginengine.Extension;
import org.platonos.pluginengine.Plugin;
import org.platonos.pluginengine.PluginEngine;
import org.platonos.pluginengine.logging.ILogger;
import org.platonos.pluginengine.logging.LoggerLevel;

final class PluginClassLoader
extends URLClassLoader {
    private static final String JAVASTR = "java.";
    private static final String JAVAXSTR = "javax.";
    private static final String PLUGINENGINESTR = "org.platonos.pluginengine";
    private static final String ENTRY_SEP = "!/";
    private static final String CLASSSTR = ".class";
    private static final String JARSTR = ".jar";
    private static final String ZIPSTR = ".zip";
    private static final String PRIVATE = ".pluginprivate.";
    private final Map<String, String> packagesMap = new HashMap<String, String>(100);
    private final Plugin plugin;
    private final ILogger logger;
    private final AccessControlContext acc;
    private final PluginArchiveURLClassPath ucp;
    private static final FilenameFilter embeddedLibraryFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return (name = name.toLowerCase()).endsWith(PluginClassLoader.JARSTR) || name.endsWith(PluginClassLoader.ZIPSTR);
        }
    };

    static PluginClassLoader createClassLoader(Plugin plugin) {
        URL[] classpath;
        URL pluginURL = plugin.getPluginURL();
        if (pluginURL == null) {
            classpath = new URL[]{};
        } else if (plugin.isArchive()) {
            classpath = new URL[]{pluginURL};
        } else {
            File archive = Util.urlToFile(pluginURL);
            File[] libraryFiles = archive.listFiles(embeddedLibraryFilter);
            classpath = new URL[libraryFiles.length + 1];
            classpath[0] = pluginURL;
            for (int i = 0; i < libraryFiles.length; ++i) {
                try {
                    classpath[i + 1] = libraryFiles[i].toURI().toURL();
                    continue;
                }
                catch (MalformedURLException ex) {
                    plugin.getPluginEngine().getLogger().log(LoggerLevel.WARNING, "Error adding library to URL classpath: " + libraryFiles[i], ex);
                }
            }
        }
        return new PluginClassLoader(classpath, plugin);
    }

    private PluginClassLoader(URL[] urls, Plugin plugin) {
        super(urls, PluginEngine.class.getClassLoader());
        this.plugin = plugin;
        this.logger = plugin.getPluginEngine().getLogger();
        if (plugin.isArchive()) {
            this.acc = AccessController.getContext();
            this.ucp = new PluginArchiveURLClassPath(urls);
        } else {
            this.acc = null;
            this.ucp = null;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Class<?> loadClassFromClassPath(String className) throws ClassNotFoundException {
        Class<?> clazz = super.findLoadedClass(className);
        if (clazz == null) {
            clazz = this.findClass(className);
        }
        if (clazz != null) {
            if (!this.plugin.start()) {
                throw new ClassNotFoundException("Unable to start Plugin \"" + this.plugin + "\". Class cannot be acquired: " + className);
            }
        } else {
            throw new ClassNotFoundException(className);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClassFromDependentLoader(String className) {
        Plugin plugin = this.plugin;
        synchronized (plugin) {
        }
        if (className.indexOf(PRIVATE) > 0) {
            String message = "Blocked dependent loader access to package \".pluginprivate.\" in plugin \"" + this.plugin + "\" for: " + className;
            this.logger.log(LoggerLevel.FINE, message, null);
            return null;
        }
        try {
            Class<?> clazz = this.loadClassFromClassPath(className);
            this.logger.log(LoggerLevel.FINE, "Found class in dependent Plugin \"" + this.plugin + "\": " + className, null);
            return clazz;
        }
        catch (ClassNotFoundException ex) {
            this.logger.log(LoggerLevel.FINE, "Unable to find class in dependent Plugin \"" + this.plugin + "\": " + className, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getResourceFromDependentLoader(String name) {
        Plugin plugin = this.plugin;
        synchronized (plugin) {
        }
        URL url = this.getResourceFromClassPath(name);
        this.logger.log(LoggerLevel.FINE, "Found resource in dependent Plugin \"" + this.plugin + "\": " + name, null);
        return url;
    }

    @Override
    public Class<?> findClass(final String className) throws ClassNotFoundException {
        for (Extension extension : this.plugin.getExtensions()) {
            if (!extension.extensionClassLoader.isExtensionClass(className)) continue;
            Class<?> clazz = extension.extensionClassLoader.loadExtensionClass(className);
            if (clazz == null) {
                throw new ClassNotFoundException(className);
            }
            return clazz;
        }
        try {
            return super.findClass(className);
        }
        catch (ClassNotFoundException ex) {
            if (!this.plugin.isArchive()) {
                throw ex;
            }
            if (this.packagesMap.isEmpty()) {
                this.buildPackagesMap();
            }
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws ClassNotFoundException {
                        String classNamePath = className.replace('.', '/');
                        int index = classNamePath.lastIndexOf(47);
                        if (index == -1) {
                            throw new ClassNotFoundException(className);
                        }
                        String packageName = classNamePath.substring(0, index);
                        if (!PluginClassLoader.this.packagesMap.containsKey(packageName)) {
                            throw new ClassNotFoundException(className);
                        }
                        String libName = (String)PluginClassLoader.this.packagesMap.get(packageName);
                        try {
                            ZipEntry entry;
                            ZipFile parFile = new ZipFile(PluginClassLoader.this.getURLs()[0].getFile());
                            ZipInputStream libInput = new ZipInputStream(parFile.getInputStream(parFile.getEntry(libName)));
                            String fileName = classNamePath + PluginClassLoader.CLASSSTR;
                            while ((entry = libInput.getNextEntry()) != null) {
                                int read;
                                if (!fileName.equals(entry.getName())) continue;
                                int size = (int)entry.getSize();
                                if (size == -1) {
                                    parFile = new ZipFile(PluginClassLoader.this.plugin.getPluginURL().getFile());
                                    InputStream input = parFile.getInputStream(parFile.getEntry(libName));
                                    ZipScanner scanner = new ZipScanner(input);
                                    while ((entry = scanner.getNextEntry()) != null) {
                                        if (!fileName.equals(entry.getName())) continue;
                                        size = (int)entry.getSize();
                                        break;
                                    }
                                    input.close();
                                }
                                byte[] data = new byte[size];
                                int off = 0;
                                int len = data.length;
                                while ((read = libInput.read(data, off, len)) > 0) {
                                    off += read;
                                    len -= read;
                                }
                                libInput.close();
                                parFile.close();
                                PluginClassLoader.this.logger.log(LoggerLevel.FINE, "Found class in Plugin \"" + PluginClassLoader.this.getPlugin() + "\" in embedded library \"" + libName + "\": " + className, null);
                                return PluginClassLoader.this.defineClass(className, data, 0, data.length);
                            }
                        }
                        catch (IOException ex) {
                            PluginClassLoader.this.logger.log(LoggerLevel.SEVERE, "Error parsing Plugin archive.", ex);
                        }
                        throw new ClassNotFoundException(className);
                    }
                });
            }
            catch (PrivilegedActionException ex2) {
                throw (ClassNotFoundException)ex2.getException();
            }
        }
    }

    private URL getResourceFromClassPath(final String name) {
        URL url = this.findResource(name);
        if (url == null && this.plugin.isArchive()) {
            url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return PluginClassLoader.this.ucp.getParResource(name);
                }
            }, this.acc);
        }
        if (url == null) {
            url = this.getParent() != null ? this.getParent().getResource(name) : ClassLoader.getSystemResource(name);
        }
        if (url != null && !this.plugin.start()) {
            url = null;
            this.logger.log(LoggerLevel.WARNING, "Unable to start Plugin \"" + this.plugin + "\". Resource cannot be acquired: " + name, null);
        }
        return url;
    }

    @Override
    public URL getResource(String name) {
        URL url;
        block1: {
            url = this.getResourceFromClassPath(name);
            if (url != null) break block1;
            for (Dependency dependency : this.plugin.getDependencies()) {
                if (dependency.isResolved() && (url = dependency.getResolvedToPlugin().pluginClassloader.getResourceFromDependentLoader(name)) != null) break;
            }
        }
        return url;
    }

    @Override
    protected String findLibrary(String libName) {
        libName = System.mapLibraryName(libName);
        try {
            String path = this.plugin.getExtractedResourcePath(libName);
            this.logger.log(LoggerLevel.FINE, "Found library in Plugin \"" + this.getPlugin() + "\": " + libName + " path: " + path, null);
            return path;
        }
        catch (IOException ex) {
            this.logger.log(LoggerLevel.WARNING, "Unable to find library in Plugin \"" + this.getPlugin() + "\": " + libName, ex);
            return super.findLibrary(libName);
        }
    }

    private synchronized void buildPackagesMap() {
        try {
            ZipFile zipFile = new ZipFile(this.plugin.getPluginURL().getFile());
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry embededEntry;
                ZipEntry parEntry = entries.nextElement();
                String parEntryName = parEntry.getName().toLowerCase();
                if ((parEntryName.indexOf(47) != -1 || !parEntryName.endsWith(JARSTR)) && !parEntryName.endsWith(ZIPSTR)) continue;
                String libName = parEntry.getName();
                ZipInputStream input = new ZipInputStream(zipFile.getInputStream(parEntry));
                while ((embededEntry = input.getNextEntry()) != null) {
                    String name = embededEntry.getName();
                    int index = name.lastIndexOf(47);
                    if (index != -1 && index < name.length() - 1) {
                        name = name.substring(0, index);
                    }
                    if (this.packagesMap.containsKey(name)) continue;
                    this.packagesMap.put(name, libName);
                }
            }
        }
        catch (IOException ex) {
            this.logger.log(LoggerLevel.SEVERE, "Error parsing Plugin archive: " + this.plugin.getPluginURL(), ex);
        }
    }

    Plugin getPlugin() {
        return this.plugin;
    }

    public String toString() {
        return "PluginClassLoader(" + this.plugin + ")";
    }

    private static class ZipScanner {
        private static final int LOCHDR = 30;
        private static final int EXTHDR = 16;
        private static final long LOCSIG = 67324752L;
        private static final long EXTSIG = 134695760L;
        private static final int LOCFLG = 6;
        private static final int LOCHOW = 8;
        private static final int LOCSIZ = 18;
        private static final int LOCLEN = 22;
        private static final int LOCNAM = 26;
        private static final int EXTSIZ = 8;
        private static final int EXTLEN = 12;
        private final InputStream in;
        private ZipEntry entry;
        private byte[] loc = new byte[30];

        public ZipScanner(InputStream in) {
            this.in = new BufferedInputStream(in, 512);
        }

        public ZipEntry getNextEntry() throws IOException {
            int read;
            int off = 0;
            int len = 30;
            while ((read = this.in.read(this.loc, off, len)) > 0) {
                off += read;
                len -= read;
            }
            if (ZipScanner.get32(this.loc, 0) != 67324752L) {
                return null;
            }
            byte[] name = new byte[this.loc[26]];
            off = 0;
            len = this.loc[26];
            while ((read = this.in.read(name, off, len)) > 0) {
                off += read;
                len -= read;
            }
            int flag = ZipScanner.get16(this.loc, 6);
            int method = ZipScanner.get16(this.loc, 8);
            if (method == 8 && (flag & 8) == 8) {
                byte[] extheader = new byte[16];
                while (this.in.available() > 0) {
                    extheader[0] = extheader[1];
                    extheader[1] = extheader[2];
                    extheader[2] = extheader[3];
                    extheader[3] = (byte)this.in.read();
                    if (extheader[0] != 80 || ZipScanner.get32(extheader, 0) != 134695760L) continue;
                    off = 4;
                    len = 12;
                    while ((read = this.in.read(extheader, off, len)) > 0) {
                        off += read;
                        len -= read;
                    }
                    this.entry = new ZipEntry(new String(name));
                    this.entry.setMethod(method);
                    this.entry.setCrc(flag);
                    this.entry.setSize(ZipScanner.get32(extheader, 12));
                    this.entry.setCompressedSize(ZipScanner.get32(extheader, 8));
                    return this.entry;
                }
            } else {
                this.entry = new ZipEntry(new String(name));
                this.entry.setMethod(method);
                this.entry.setSize(ZipScanner.get32(this.loc, 22));
                long cSize = ZipScanner.get32(this.loc, 18);
                this.entry.setCompressedSize(cSize);
                if (cSize > 0L) {
                    byte[] data = new byte[(int)cSize];
                    off = 0;
                    len = (int)cSize;
                    while ((read = this.in.read(data, off, len)) > 0) {
                        off += read;
                        len -= read;
                    }
                }
                return this.entry;
            }
            return null;
        }

        private static final int get16(byte[] b, int off) {
            return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8;
        }

        private static final long get32(byte[] b, int off) {
            return (long)ZipScanner.get16(b, off) | (long)ZipScanner.get16(b, off + 2) << 16;
        }
    }

    private class PluginArchiveURLClassPath {
        private URL[] urls;

        public PluginArchiveURLClassPath(URL[] urls) {
            this.urls = urls;
        }

        public URL[] getURLs() {
            return this.urls;
        }

        public void addURL(URL url) {
            URL[] temp = this.urls;
            this.urls = new URL[temp.length + 1];
            System.arraycopy(temp, 0, this.urls, 0, temp.length);
            this.urls[temp.length] = url;
        }

        public URL findResource(String name, boolean check) {
            URL url = this.getParResource(name);
            return null != url ? url : null;
        }

        public Enumeration<URL> findResources(final String name, final boolean check) {
            return new Enumeration<URL>(){
                URL url;
                private boolean hasMore;
                {
                    this.url = PluginArchiveURLClassPath.this.findResource(name, check);
                    this.hasMore = null != this.url;
                }

                @Override
                public boolean hasMoreElements() {
                    return this.hasMore;
                }

                @Override
                public URL nextElement() {
                    if (this.hasMore) {
                        this.hasMore = false;
                        return this.url;
                    }
                    return null;
                }
            };
        }

        private URL getParResource(String name) {
            if (PluginClassLoader.this.packagesMap.isEmpty()) {
                PluginClassLoader.this.buildPackagesMap();
            }
            int index = name.lastIndexOf(47);
            String packageName = null;
            packageName = index > 0 ? name.substring(0, index) : name;
            if (PluginClassLoader.this.packagesMap.containsKey(packageName)) {
                String libName = (String)PluginClassLoader.this.packagesMap.get(packageName);
                try {
                    ZipEntry entry;
                    ZipFile parFile = new ZipFile(this.getURLs()[0].getFile());
                    InputStream input = parFile.getInputStream(parFile.getEntry(libName));
                    ZipInputStream libInput = new ZipInputStream(input);
                    while ((entry = libInput.getNextEntry()) != null) {
                        int read;
                        if (!name.equals(entry.getName())) continue;
                        int size = (int)entry.getSize();
                        if (size == -1) {
                            parFile = new ZipFile(PluginClassLoader.this.plugin.getPluginURL().getFile());
                            input = parFile.getInputStream(parFile.getEntry(libName));
                            ZipScanner scanner = new ZipScanner(input);
                            while ((entry = scanner.getNextEntry()) != null) {
                                if (!name.equals(entry.getName())) continue;
                                size = (int)entry.getSize();
                                break;
                            }
                            input.close();
                        }
                        byte[] data = new byte[size];
                        int off = 0;
                        int len = data.length;
                        while ((read = libInput.read(data, off, len)) > 0) {
                            off += read;
                            len -= read;
                        }
                        StringBuffer buffer = new StringBuffer(this.getURLs()[0].toString());
                        buffer.append(PluginClassLoader.ENTRY_SEP);
                        buffer.append(libName);
                        buffer.append(PluginClassLoader.ENTRY_SEP);
                        buffer.append(name);
                        return new URL("jar", "", -1, buffer.toString(), new EmbededURLStreamHandler(data));
                    }
                }
                catch (Exception ex) {
                    PluginClassLoader.this.logger.log(LoggerLevel.SEVERE, "Error parsing Plugin archive: " + PluginClassLoader.this.plugin.getPluginURL(), ex);
                }
                return null;
            }
            return null;
        }
    }

    private class EmbededURLConnection
    extends JarURLConnection {
        private byte[] data;
        private String contentType;
        private FilePermission permission;
        private static final String READ = "read";
        private static final String FILE_PROT = "file:";

        public EmbededURLConnection(URL url, byte[] data) throws MalformedURLException, IOException {
            super(url);
            this.data = data;
        }

        @Override
        public Object getContent() throws IOException {
            throw new UnsupportedOperationException("getContent() is unsupported.");
        }

        @Override
        public int getContentLength() {
            return this.data.length;
        }

        @Override
        public String getContentType() {
            if (null == this.contentType) {
                try {
                    this.contentType = EmbededURLConnection.guessContentTypeFromStream(new ByteArrayInputStream(this.data));
                }
                catch (IOException ex) {
                    PluginClassLoader.this.logger.log(LoggerLevel.SEVERE, "Error calling guessContentTypeFromStream.", ex);
                }
                if (null == this.contentType) {
                    String file = this.url.getFile();
                    this.contentType = EmbededURLConnection.guessContentTypeFromName(file.substring(file.lastIndexOf(PluginClassLoader.ENTRY_SEP) + 2));
                }
                if (null == this.contentType) {
                    this.contentType = "content/unknown";
                }
            }
            return this.contentType;
        }

        @Override
        public String getHeaderField(String arg0) {
            throw new UnsupportedOperationException("getHeaderField(String arg0) is unsupported.");
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        @Override
        public JarFile getJarFile() throws IOException {
            throw new UnsupportedOperationException("getJarFile() is unsupported.");
        }

        @Override
        public Permission getPermission() throws IOException {
            if (null == this.permission) {
                String file = this.getURL().getFile();
                int a = file.indexOf(FILE_PROT);
                int index = file.indexOf(33);
                file = file.substring(a + FILE_PROT.length(), index);
                this.permission = new FilePermission(file, READ);
            }
            return this.permission;
        }

        @Override
        public void connect() throws IOException {
        }
    }

    private class EmbededURLStreamHandler
    extends URLStreamHandler {
        private byte[] data;

        public EmbededURLStreamHandler(byte[] data) {
            this.data = data;
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return new EmbededURLConnection(url, this.data);
        }
    }
}

