/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.table;

import es.uvigo.ei.sing.commons.csv.entities.CsvFormat;
import es.uvigo.ei.sing.commons.csv.io.CsvWriter;
import es.uvigo.ei.sing.s2p.gui.components.dialog.ExportCsvDialog;
import es.uvigo.ei.sing.s2p.gui.table.CsvTable;
import es.uvigo.ei.sing.s2p.gui.util.CsvUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.TableColumnExt;

public class ExtendedCsvTable
extends CsvTable {
    private static final long serialVersionUID = 1L;
    private CustomColumnControlButton columnControlButton;
    private boolean showVisibilityActions = true;

    public ExtendedCsvTable(TableModel dm) {
        super(dm);
        this.init();
    }

    private void init() {
        this.columnControlButton = new CustomColumnControlButton(this);
        this.setColumnControl((JComponent)((Object)this.columnControlButton));
    }

    public void addExportToCsvAction() {
        this.addAction(new AbstractAction("Export to CSV"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtendedCsvTable.this.exportToCsv();
            }
        });
    }

    public void setColumVisibilityActionsEnabled(boolean enabled) {
        this.showVisibilityActions = enabled;
        this.columnControlButton.update();
    }

    public void addAction(Action a) {
        this.getActionMap().put(this.actionName(a), a);
        this.columnControlButton.update();
    }

    private String actionName(Action a) {
        return "column." + a.getValue("Name");
    }

    protected void exportToCsv() {
        ExportCsvDialog dialog = new ExportCsvDialog(this.getDialogParent());
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            try {
                this.exportToFile(dialog.getSelectedFile(), CsvUtils.csvFormat(dialog.getSelectedCsvFormat()));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog((Component)((Object)this), "There was an error writing to " + dialog.getSelectedFile(), "Input error", 0);
            }
        }
    }

    private Window getDialogParent() {
        return SwingUtilities.getWindowAncestor((Component)((Object)this));
    }

    public void exportToFile(File file, CsvFormat csvFormat) throws IOException {
        boolean header = this.getTableHeader() != null && this.getTableHeader().isVisible();
        List<Integer> visibleColumns = this.getVisibleColumns();
        List<Integer> visibleRows = this.getVisibleRows();
        List headerData = header ? this.getTableHeader(visibleColumns) : Collections.emptyList();
        Object[][] data = this.getData(visibleRows, visibleColumns);
        csvFormat.setDecimalFormatterMaximumFractionDigits(Integer.MAX_VALUE);
        CsvWriter csvWriter = CsvWriter.of((CsvFormat)csvFormat);
        csvWriter.write(data, headerData, file);
    }

    public TableColumnExt getTableColumnExt(int modelIndex) {
        return (TableColumnExt)this.getColumns(true).get(modelIndex);
    }

    public void setColumnsVisibility(List<Integer> columnIndices, boolean visible) {
        columnIndices.stream().map(this::getTableColumnExt).forEach(column -> column.setVisible(visible));
    }

    private class CustomColumnControlButton
    extends ColumnControlButton {
        private static final long serialVersionUID = 1L;

        public CustomColumnControlButton(JXTable table) {
            super(table);
        }

        protected void createVisibilityActions() {
            if (ExtendedCsvTable.this.showVisibilityActions) {
                super.createVisibilityActions();
            }
        }

        public void update() {
            super.populatePopup();
        }
    }
}

