/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.operations;

import es.uvigo.ei.sing.s2p.core.entities.Condition;
import es.uvigo.ei.sing.s2p.core.entities.ConditionSummary;
import es.uvigo.ei.sing.s2p.core.entities.ConditionsSummary;
import es.uvigo.ei.sing.s2p.core.entities.SpotSummary;
import es.uvigo.ei.sing.s2p.core.entities.SpotsData;
import es.uvigo.ei.sing.s2p.core.util.ArrayUtils;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class ConditionsSummarizer {
    public static ConditionsSummary summary(List<String> spots, SpotsData data) {
        ConditionsSummary summary = new ConditionsSummary();
        data.getConditions().forEach(c -> summary.put(c, ConditionsSummarizer.conditionSummary(spots, c)));
        return summary;
    }

    private static ConditionSummary conditionSummary(List<String> spots, Condition c) {
        ConditionSummary summary = new ConditionSummary();
        spots.forEach(spot -> summary.put(spot, ConditionsSummarizer.spotSummary(spot, c)));
        return summary;
    }

    private static SpotSummary spotSummary(String spot, Condition c) {
        LinkedList<Double> spotValues = new LinkedList<Double>();
        c.getSamples().forEach(s -> {
            double spotValue;
            if (s.getSpotValues().containsKey(spot) && !Double.isNaN(spotValue = s.getSpotValues().get(spot).doubleValue())) {
                spotValues.add(spotValue);
            }
        });
        DescriptiveStatistics statistics = new DescriptiveStatistics(ArrayUtils.doubleArray(spotValues));
        return new SpotSummary((int)statistics.getN(), c.getSamples().size(), statistics.getMean(), statistics.getStandardDeviation(), spotValues);
    }
}

