/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.spots.comparison;

import es.uvigo.ei.sing.s2p.core.entities.Condition;
import es.uvigo.ei.sing.s2p.core.entities.SpotMascotIdentifications;
import es.uvigo.ei.sing.s2p.core.entities.Util;
import es.uvigo.ei.sing.s2p.core.operations.StringSetComparison;
import es.uvigo.ei.sing.s2p.gui.UISettings;
import es.uvigo.ei.sing.s2p.gui.components.VennDiagram;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.sing_group.gc4s.list.ExtendedDefaultListModel;

public class ProteinDataComparisonInformationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Condition condition1;
    private Condition condition2;
    private JLabel informationLabel;
    private VennDiagram vennDiagram;
    private JRadioButton condition1Rbtn;
    private JRadioButton condition2Rbtn;
    private JRadioButton commonRbtn;
    private ExtendedDefaultListModel<String> itemsListModel;
    private boolean showProteinIdentifications = false;
    private Optional<SpotMascotIdentifications> mascotIdentifications = Optional.empty();
    private StringSetComparison setComparison;

    public ProteinDataComparisonInformationPanel(Condition condition1, Condition condition2) {
        this.condition1 = condition1;
        this.condition2 = condition2;
        this.initComponent();
        this.updateComponents();
    }

    private void initComponent() {
        this.setBorder(BorderFactory.createTitledBorder("Condition comparison"));
        this.setBackground(UISettings.BG_COLOR);
        this.setLayout(new BorderLayout());
        this.add(this.getVennDiagramPanel(), "Center");
        this.add(this.getItemsListPanel(), "East");
    }

    private Component getVennDiagramPanel() {
        JPanel vennDiagramPanel = new JPanel(new BorderLayout());
        vennDiagramPanel.add((Component)this.getInformationLabel(), "North");
        vennDiagramPanel.add((Component)this.getVennDiagram(), "South");
        vennDiagramPanel.setOpaque(false);
        return vennDiagramPanel;
    }

    private JLabel getInformationLabel() {
        if (this.informationLabel == null) {
            this.informationLabel = new JLabel("", 2);
            this.informationLabel.setFont(this.informationLabel.getFont().deriveFont(0));
        }
        return this.informationLabel;
    }

    private VennDiagram getVennDiagram() {
        if (this.vennDiagram == null) {
            this.vennDiagram = new VennDiagram(this.condition1.getName(), this.condition2.getName(), 0.0, 0.0, 0.0);
        }
        return this.vennDiagram;
    }

    private Component getItemsListPanel() {
        JPanel itemsListPanel = new JPanel(new BorderLayout());
        itemsListPanel.setOpaque(false);
        this.condition1Rbtn = new JRadioButton(this.condition1.getName());
        this.condition2Rbtn = new JRadioButton(this.condition2.getName());
        this.commonRbtn = new JRadioButton("Common");
        this.commonRbtn.setSelected(true);
        ItemListener itemListener = e -> {
            if (e.getStateChange() == 1) {
                this.modeChanged();
            }
        };
        this.condition1Rbtn.addItemListener(itemListener);
        this.condition2Rbtn.addItemListener(itemListener);
        this.commonRbtn.addItemListener(itemListener);
        ButtonGroup group = new ButtonGroup();
        group.add(this.condition1Rbtn);
        group.add(this.condition2Rbtn);
        group.add(this.commonRbtn);
        JPanel selectionPanel = new JPanel(new GridLayout(1, 3));
        selectionPanel.setBackground(UISettings.BG_COLOR);
        selectionPanel.add(this.condition1Rbtn);
        selectionPanel.add(this.condition2Rbtn);
        selectionPanel.add(this.commonRbtn);
        this.itemsListModel = new ExtendedDefaultListModel();
        this.itemsListModel.addElements(this.getCommonElements());
        JList<String> itemsList = new JList<String>((ListModel<String>)this.itemsListModel);
        itemsList.setFixedCellWidth(200);
        itemsListPanel.add((Component)selectionPanel, "North");
        itemsListPanel.add((Component)new JScrollPane(itemsList), "Center");
        return itemsListPanel;
    }

    private void modeChanged() {
        this.updateItemsList();
    }

    private void updateItemsList() {
        ArrayList<String> items = new ArrayList<String>();
        if (this.condition1Rbtn.isSelected()) {
            items.addAll(this.getConditionUniqueElements(this.condition1));
        } else if (this.condition2Rbtn.isSelected()) {
            items.addAll(this.getConditionUniqueElements(this.condition2));
        } else {
            items.addAll(this.getCommonElements());
        }
        this.itemsListModel.clear();
        this.itemsListModel.addElements(items);
        this.updateUI();
    }

    private Collection<? extends String> getConditionUniqueElements(Condition condition) {
        Set<String> conditionElemnents = this.getConditionElements(condition);
        conditionElemnents.removeAll(this.getCommonElements());
        return conditionElemnents;
    }

    private List<String> getCommonElements() {
        Set<String> condition1Proteins = this.getConditionElements(this.condition1);
        Set<String> condition2Proteins = this.getConditionElements(this.condition2);
        HashSet<String> intersection = new HashSet<String>(condition1Proteins);
        intersection.retainAll(condition2Proteins);
        return new ArrayList<String>(intersection);
    }

    private void updateComponents() {
        this.setComparison = new StringSetComparison(this.getConditionElements(this.condition1), this.getConditionElements(this.condition2));
        this.updateRadioButtons();
        this.updateItemsList();
        this.updateLabels();
        this.updateUI();
    }

    private void updateLabels() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append(this.getItemLabel()).append(" present in any sample of: <ul><li>Both conditions: ").append(this.setComparison.getIntersectionSize()).append(" </li><li> ").append(this.condition1.getName()).append(" (only): ").append(this.setComparison.getSet1UniqueSize()).append("  </li><li>  ").append(this.condition2.getName()).append(" (only): ").append(this.setComparison.getSet2UniqueSize()).append("</li></ul></html>");
        this.getInformationLabel().setText(sb.toString());
        this.getInformationLabel().updateUI();
        int max = Math.max(this.setComparison.getSet1Size(), this.setComparison.getSet2Size());
        this.getVennDiagram().setAreas(this.condition1.getName(), this.condition2.getName(), (double)this.setComparison.getSet1Size() / (double)max, (double)this.setComparison.getSet2Size() / (double)max, (double)this.setComparison.getIntersectionSize() / (double)max);
    }

    private void updateRadioButtons() {
        this.condition1Rbtn.setText(this.condition1.getName());
        this.condition2Rbtn.setText(this.condition2.getName());
        this.commonRbtn.setSelected(true);
    }

    private String getItemLabel() {
        return this.showProteinIdentifications ? "Proteins" : "Spots";
    }

    private Set<String> getConditionElements(Condition condition) {
        if (this.showProteinIdentifications) {
            if (this.mascotIdentifications.isPresent()) {
                return Util.getConditionProteins((Condition)condition, (SpotMascotIdentifications)this.mascotIdentifications.get());
            }
            return Collections.emptySet();
        }
        return condition.getSpots();
    }

    public void setComparison(Condition condition1, Condition condition2) {
        this.condition1 = condition1;
        this.condition2 = condition2;
        this.updateComponents();
    }

    public void setMascotIdentifications(SpotMascotIdentifications identifications) {
        this.mascotIdentifications = Optional.of(identifications);
    }

    public void setShowProteinIdentifications(boolean show) {
        this.showProteinIdentifications = show;
        this.updateComponents();
    }

    public void removeMascotIdentifications() {
        this.mascotIdentifications = Optional.empty();
    }
}

