/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.jsparklines_factory.builders.barchartrenderer;

import javax.swing.JTable;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;
import org.sing_group.jsparklines_factory.JSparklinesBarChartTableCellRendererFactory;
import org.sing_group.jsparklines_factory.util.TableUtils;

public class MaximumBarChartRendererBuilder {
    private JTable table;
    private int column;
    private PlotOrientation plotOrientation = JSparklinesBarChartTableCellRendererFactory.DEFAULT_ORIENTATION;
    private Double maxValue;
    private boolean largeNumbersAreGood = true;

    public MaximumBarChartRendererBuilder(JTable table, int column) {
        this.table = table;
        this.column = column;
    }

    public MaximumBarChartRendererBuilder withPlotOrientation(PlotOrientation plotOrientation) {
        this.plotOrientation = plotOrientation;
        return this;
    }

    public MaximumBarChartRendererBuilder withMaxValue(Double maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public MaximumBarChartRendererBuilder largeNumbersAreGood(boolean largeNumbersAreGood) {
        this.largeNumbersAreGood = largeNumbersAreGood;
        return this;
    }

    public JSparklinesBarChartTableCellRenderer build() {
        this.checkMaxValue();
        return JSparklinesBarChartTableCellRendererFactory.createMaxValueBarChartRenderer(this.table, this.column, this.plotOrientation, this.maxValue, this.largeNumbersAreGood);
    }

    private void checkMaxValue() {
        if (this.maxValue == null) {
            this.maxValue = TableUtils.getMaxColumnValue(this.table, this.column);
        }
    }
}

