/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.hlfernandez.utilities.builder;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class JButtonBuilder {
    private String text;
    private String tooltip;
    private Icon icon;
    private Action action;
    private boolean enabled = true;

    private JButtonBuilder() {
    }

    public static JButtonBuilder newJButtonBuilder() {
        return new JButtonBuilder();
    }

    public JButtonBuilder withText(String text) {
        this.text = text;
        return this;
    }

    public JButtonBuilder withTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public JButtonBuilder withIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public JButtonBuilder thatDoes(Action action) {
        this.action = action;
        return this;
    }

    public JButtonBuilder disabled() {
        this.enabled = false;
        return this;
    }

    public JButton build() {
        JButton build = new JButton(this.text, this.icon);
        if (this.text != null) {
            build.setText(this.text);
        }
        if (this.tooltip != null) {
            build.setToolTipText(this.tooltip);
        }
        if (this.action != null) {
            build.setAction(this.action);
            this.fixAction();
        }
        if (this.icon != null) {
            build.setIcon(this.icon);
        }
        build.setEnabled(this.enabled);
        return build;
    }

    private void fixAction() {
        if (this.action.getValue("Name") == null) {
            this.action.putValue("Name", this.text);
        }
        if (this.action.getValue("Name") == null) {
            this.action.putValue("ShortDescription", this.tooltip);
        }
        if (this.action.getValue("Name") == null) {
            this.action.putValue("LongDescription", this.tooltip);
        }
    }
}

