/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.wizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXLabel;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.gc4s.wizard.WizardStep;
import org.sing_group.gc4s.wizard.event.WizardStepEvent;
import org.sing_group.gc4s.wizard.event.WizardStepListener;

public class Wizard
extends JDialog
implements WizardStepListener {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_INITIAL_HEIGHT = 500;
    public static final int DEFAULT_INITIAL_WIDTH = 700;
    private List<WizardStep> steps;
    private Window parent;
    private JPanel wizardMainPanel;
    private CardLayout wizardMainPanelLayout;
    private JButton nextStepButton;
    private JButton previousStepButton;
    private JButton cancelStepButton;
    private List<JLabel> wizardStepsSidebarLabels = new LinkedList<JLabel>();
    private int initialHeight = 500;
    private int initialWidth = 700;
    private boolean canceled = false;
    private int currentStep = 0;

    public Wizard(Window parent, String wizardTitle, List<WizardStep> steps) {
        super(parent);
        this.parent = parent;
        this.setTitle(wizardTitle);
        this.steps = steps;
        this.initComponent();
    }

    private void initComponent() {
        this.setModal(true);
        this.setResizable(false);
        this.setContentPane(this.getDialogContentPane());
        this.setSize(this.initialWidth, this.initialHeight);
        this.setPreferredSize(new Dimension(this.initialWidth, this.initialHeight));
        this.centerDialogOnScreen();
        this.pack();
    }

    private Container getDialogContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)this.getWizardStepsSidebar(), "West");
        contentPane.add((Component)this.getWizardMainPanel(), "Center");
        contentPane.add((Component)this.getWizardButtonsPanel(), "South");
        return contentPane;
    }

    private JComponent getWizardStepsSidebar() {
        JPanel wizardStepsSidebar = new JPanel();
        wizardStepsSidebar.setLayout(new BoxLayout(wizardStepsSidebar, 1));
        wizardStepsSidebar.add(Box.createVerticalGlue());
        this.steps.forEach(s -> {
            JXLabel label = new JXLabel(s.getStepTitle());
            label.setLineWrap(true);
            label.setMaximumSize(new Dimension(150, 1000));
            label.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            wizardStepsSidebar.add((Component)label);
            this.wizardStepsSidebarLabels.add((JLabel)label);
        });
        wizardStepsSidebar.add(Box.createVerticalGlue());
        CenteredJPanel component = new CenteredJPanel(wizardStepsSidebar);
        component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 20));
        this.updateWizardStepSidebarLabelsStyle();
        return component;
    }

    private void updateWizardStepSidebarLabelsStyle() {
        for (int i = 0; i < this.wizardStepsSidebarLabels.size(); ++i) {
            if (i == this.currentStep) {
                this.wizardStepsSidebarLabels.get(i).setForeground(Color.BLACK);
                continue;
            }
            this.wizardStepsSidebarLabels.get(i).setForeground(Color.GRAY);
        }
    }

    private JComponent getWizardMainPanel() {
        this.wizardMainPanel = new JPanel();
        this.wizardMainPanelLayout = new CardLayout();
        this.wizardMainPanel.setLayout(this.wizardMainPanelLayout);
        this.steps.forEach(s -> this.wizardMainPanel.add(new WizardStepPanel((WizardStep)s)));
        this.wizardMainPanelLayout.show(this.wizardMainPanel, this.steps.get(0).getStepTitle());
        return this.wizardMainPanel;
    }

    private JComponent getWizardButtonsPanel() {
        JPanel wizardButtonsPanel = new JPanel();
        wizardButtonsPanel.setLayout(new BoxLayout(wizardButtonsPanel, 0));
        wizardButtonsPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        wizardButtonsPanel.add(Box.createHorizontalGlue());
        wizardButtonsPanel.add(this.getPreviousButton());
        wizardButtonsPanel.add(Box.createHorizontalStrut(5));
        wizardButtonsPanel.add(this.getNextButton());
        wizardButtonsPanel.add(Box.createHorizontalStrut(5));
        wizardButtonsPanel.add(this.getCancelButton());
        return wizardButtonsPanel;
    }

    private JButton getPreviousButton() {
        if (this.previousStepButton == null) {
            this.previousStepButton = new JButton("Back");
            this.previousStepButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Wizard.this.showPrevioustStep();
                }
            });
            this.previousStepButton.setEnabled(this.canMoveToPreviousStep());
        }
        return this.previousStepButton;
    }

    private JButton getNextButton() {
        if (this.nextStepButton == null) {
            this.nextStepButton = new JButton("Next");
            this.nextStepButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Wizard.this.showNextStep();
                }
            });
            this.nextStepButton.setEnabled(this.canMoveToNextStep());
        }
        return this.nextStepButton;
    }

    private JButton getCancelButton() {
        if (this.cancelStepButton == null) {
            this.cancelStepButton = new JButton("Cancel");
            this.cancelStepButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Wizard.this.cancelWizard();
                }
            });
        }
        return this.cancelStepButton;
    }

    private void cancelWizard() {
        this.canceled = true;
        this.dispose();
    }

    private void showNextStep() {
        if (this.isFinalStep()) {
            this.wizardFinished();
        } else if (this.canMoveToNextStep()) {
            this.wizardMainPanelLayout.next(this.wizardMainPanel);
            ++this.currentStep;
            this.stepChanged();
        }
    }

    protected void wizardFinished() {
        this.canceled = false;
        this.dispose();
    }

    private void showPrevioustStep() {
        if (this.canMoveToPreviousStep()) {
            this.wizardMainPanelLayout.previous(this.wizardMainPanel);
            --this.currentStep;
            this.stepChanged();
        }
    }

    private boolean canMoveToPreviousStep() {
        return this.currentStep > 0;
    }

    private boolean canMoveToNextStep() {
        return this.steps.get(this.currentStep).isStepCompleted();
    }

    private void stepChanged() {
        this.checkButtonsStatus();
        this.updateWizardStepSidebarLabelsStyle();
        this.checkStep();
        this.notifyStepEntered();
    }

    private void checkStep() {
        if (this.isFinalStep()) {
            this.nextStepButton.setText("Finish");
        } else {
            this.nextStepButton.setText("Next");
        }
    }

    private void notifyStepEntered() {
        this.steps.get(this.currentStep).stepEntered();
    }

    private boolean isFinalStep() {
        return this.currentStep == this.steps.size() - 1;
    }

    protected void centerDialogOnScreen() {
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    @Override
    public void wizardStepCompleted(WizardStepEvent event) {
        this.checkButtonsStatus();
    }

    @Override
    public void wizardStepUncompleted(WizardStepEvent event) {
        this.checkButtonsStatus();
    }

    private void checkButtonsStatus() {
        this.nextStepButton.setEnabled(this.canMoveToNextStep());
        this.previousStepButton.setEnabled(this.canMoveToPreviousStep());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected List<WizardStep> getSteps() {
        return this.steps;
    }

    private class WizardStepPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private WizardStep step;

        public WizardStepPanel(WizardStep step) {
            this.step = step;
            this.init();
        }

        private void init() {
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
            this.add((Component)this.getStepLabel(), "North");
            this.add((Component)this.step.getStepComponent(), "Center");
            this.step.addWizardStepListener(Wizard.this);
        }

        private JLabel getStepLabel() {
            JXLabel stepLabel = new JXLabel(this.step.getStepTitle());
            stepLabel.setFont(stepLabel.getFont().deriveFont(1, 20.0f));
            stepLabel.setLineWrap(true);
            stepLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            return stepLabel;
        }
    }
}

