/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.hlfernandez.visualization;

import es.uvigo.ei.sing.hlfernandez.utilities.StringMetrics;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class ColorKeyLegend
extends Canvas {
    private static final long serialVersionUID = 1L;
    private static final int WIDTH = 300;
    private static final int HEIGHT = 100;
    private static final Dimension SIZE = new Dimension(300, 100);
    private static final int LEGEND_WIDTH = 250;
    private static final int LEGEND_HEIGHT = 65;
    private Color lowColor;
    private Color highColor;
    private double low;
    private double high;
    private DecimalFormat decimalFormat = new DecimalFormat("0.0");

    public ColorKeyLegend(Color lowColor, Color highColor, double lowValue, double highValue) {
        this.lowColor = lowColor;
        this.highColor = highColor;
        this.low = lowValue;
        this.high = highValue;
        this.init();
    }

    private void init() {
        this.setMinimumSize(SIZE);
        this.setPreferredSize(SIZE);
        this.setSize(SIZE);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(this.getFont());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(Color.gray);
        int x = 25;
        boolean y = false;
        GradientPaint gradient = new GradientPaint(x, (float)y, this.lowColor, 250.0f, (float)y, this.highColor);
        g2.setPaint(gradient);
        g2.fill(new RoundRectangle2D.Double(x, (double)y, 250.0, 65.0, 0.0, 0.0));
        g2.setPaint(Color.black);
        g2.drawLine(x, 67, x, 77);
        g2.drawLine(x + 125, 67, x + 125, 77);
        g2.drawLine(x + 250 - 1, 67, x + 250 - 1, 77);
        StringMetrics s = new StringMetrics(g2, g2.getFont());
        String min = this.getLowValue();
        double height = s.getHeight(min);
        double width = s.getWidth(min);
        g2.drawString(min, (float)((double)x - width / 2.0), (float)(79.0 + height));
        String middle = this.getMiddle();
        height = s.getHeight(middle);
        width = s.getWidth(middle);
        g2.drawString(middle, (float)((double)(x + 125) - width / 2.0), (float)(79.0 + height));
        String max = this.getHighValue();
        height = s.getHeight(max);
        width = s.getWidth(max);
        g2.drawString(max, (float)((double)(x + 250 - 1) - width / 2.0), (float)(79.0 + height));
    }

    private String getMiddle() {
        return this.format((this.low + this.high) / 2.0);
    }

    private String getLowValue() {
        return this.format(this.low);
    }

    private String getHighValue() {
        return this.format(this.high);
    }

    private String format(double d) {
        return this.getDecimalFormatter().format(d);
    }

    private NumberFormat getDecimalFormatter() {
        return this.decimalFormat;
    }

    public void setLowColor(Color color) {
        this.lowColor = color;
        this.repaint();
    }

    public void setHighColor(Color color) {
        this.highColor = color;
        this.repaint();
    }

    public void setLowValue(double low) {
        this.low = low;
        this.repaint();
    }

    public void setHighValue(double high) {
        this.high = high;
        this.repaint();
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
        this.repaint();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.repaint();
    }
}

