/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.error;

import es.uvigo.ei.aibench.workbench.Workbench;
import es.uvigo.ei.aibench.workbench.error.DefaultErrorNotifierProvider;
import es.uvigo.ei.aibench.workbench.error.ErrorNotifier;
import es.uvigo.ei.aibench.workbench.error.ErrorNotifierProvider;
import org.apache.log4j.Logger;

public class PropertiesErrorNotifierProvider
implements ErrorNotifierProvider {
    private static final Logger LOG = Logger.getLogger((String)PropertiesErrorNotifierProvider.class.getName());
    public static final String PROPERTY_ERROR_NOTIFIER_CLASS = "error.notifier.class";
    public static final String VALUE_USE_DEFAULT = "default";

    public static String getErrorNotifierClassName() {
        return Workbench.CONFIG.getProperty(PROPERTY_ERROR_NOTIFIER_CLASS);
    }

    @Override
    public ErrorNotifier createErrorNotifier() {
        if (Workbench.CONFIG.containsKey(PROPERTY_ERROR_NOTIFIER_CLASS)) {
            String enClassName = Workbench.CONFIG.getProperty(PROPERTY_ERROR_NOTIFIER_CLASS);
            if (VALUE_USE_DEFAULT.equals(enClassName)) {
                return new DefaultErrorNotifierProvider().createErrorNotifier();
            }
            try {
                Class<?> enClass = Class.forName(enClassName);
                if (ErrorNotifier.class.isAssignableFrom(enClass)) {
                    return (ErrorNotifier)enClass.newInstance();
                }
                throw new ClassCastException(String.format("The custom error notifier class (%s) is not a valid (%s) implementation.", enClassName, ErrorNotifier.class.getName()));
            }
            catch (Exception e) {
                LOG.error((Object)("Error creating the error notifier configured in the Workbench configuration: " + enClassName), (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

