/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.operations.quantification.comparison;

import es.uvigo.ei.sing.math.statistical.corrections.Correction;
import es.uvigo.ei.sing.math.statistical.corrections.FDRCorrection;
import es.uvigo.ei.sing.s2p.core.entities.Pair;
import es.uvigo.ei.sing.s2p.core.entities.quantification.ProteinSummary;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationCondition;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationConditionSummary;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationConditionsComparison;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationConditionsComparisons;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationConditionsSummary;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationDataset;
import es.uvigo.ei.sing.s2p.core.operations.quantification.QuantificationConditionsSummarizer;
import es.uvigo.ei.sing.s2p.core.operations.quantification.comparison.NormalizationProteinSummaryTest;
import es.uvigo.ei.sing.s2p.core.operations.quantification.comparison.ProteinSummaryTest;
import es.uvigo.ei.sing.s2p.core.util.CombinationUtils;
import es.uvigo.ei.sing.s2p.core.util.StatisticsTestsUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.exception.NumberIsTooSmallException;

public class QuantificationsConditionsTest {
    private static final ProteinSummaryTest defaultProteinComparison = new NormalizationProteinSummaryTest();

    public static QuantificationConditionsComparisons compare(QuantificationDataset dataset) {
        return QuantificationsConditionsTest.compare(dataset, defaultProteinComparison);
    }

    public static QuantificationConditionsComparisons compare(QuantificationDataset dataset, ProteinSummaryTest proteinComparison) {
        return QuantificationsConditionsTest.compare(QuantificationConditionsSummarizer.summary(dataset), proteinComparison);
    }

    public static QuantificationConditionsComparisons compare(QuantificationConditionsSummary summary) {
        return QuantificationsConditionsTest.compare(summary, defaultProteinComparison);
    }

    public static QuantificationConditionsComparisons compare(QuantificationConditionsSummary summary, ProteinSummaryTest proteinComparison) {
        return new QuantificationConditionsComparisons(QuantificationsConditionsTest.compare(CombinationUtils.allPairs(summary.getConditions()), summary, proteinComparison));
    }

    private static Collection<QuantificationConditionsComparison> compare(List<Pair<QuantificationCondition, QuantificationCondition>> conditionPairs, QuantificationConditionsSummary summary, ProteinSummaryTest proteinComparison) {
        LinkedList<QuantificationConditionsComparison> comparisons = new LinkedList<QuantificationConditionsComparison>();
        conditionPairs.forEach(cP -> comparisons.add(QuantificationsConditionsTest.compare(cP, summary, proteinComparison)));
        return comparisons;
    }

    private static QuantificationConditionsComparison compare(Pair<QuantificationCondition, QuantificationCondition> cP, QuantificationConditionsSummary summary, ProteinSummaryTest proteinComparison) {
        Set<String> proteins = cP.getFirst().getProteins();
        proteins.addAll(cP.getSecond().getProteins());
        QuantificationConditionSummary firstSummary = (QuantificationConditionSummary)summary.get(cP.getFirst());
        QuantificationConditionSummary secondSummary = (QuantificationConditionSummary)summary.get(cP.getSecond());
        HashMap<String, Double> proteinTest = new HashMap<String, Double>();
        proteins.forEach(p -> {
            ProteinSummary firstProteinSummary = (ProteinSummary)firstSummary.get(p);
            ProteinSummary secondProteinSummary = (ProteinSummary)secondSummary.get(p);
            try {
                double tTest = proteinComparison.test(firstProteinSummary, secondProteinSummary);
                proteinTest.put((String)p, tTest);
            }
            catch (NumberIsTooSmallException numberIsTooSmallException) {
                // empty catch block
            }
        });
        Map<String, Double> correctedProteinTest = StatisticsTestsUtils.correct((Correction)new FDRCorrection(), proteinTest);
        return new QuantificationConditionsComparison(cP.getFirst(), cP.getSecond(), proteinTest, correctedProteinTest);
    }
}

