/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.demo;

import java.awt.Window;
import java.awt.event.ItemEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.sing_group.gc4s.demo.DemoUtils;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.gc4s.wizard.Wizard;
import org.sing_group.gc4s.wizard.WizardStep;
import org.sing_group.gc4s.wizard.event.WizardStepEvent;

public class WizardDemo {
    public static void main(String[] args) {
        Wizard dialog = new Wizard((Window)new JFrame(), "Demo Wizard", (List)WizardDemo.getWizardSteps()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void wizardFinished() {
                System.err.println("Wizard finished!");
                super.wizardFinished();
            }
        };
        DemoUtils.showDialog(dialog);
    }

    private static List<WizardStep> getWizardSteps() {
        return Arrays.asList(new WizardStep(){
            private JCheckBox checkBox;

            @Override
            public boolean isStepCompleted() {
                return this.checkBox.isSelected();
            }

            @Override
            public String getStepTitle() {
                return "Step 1";
            }

            @Override
            public JComponent getStepComponent() {
                return new CenteredJPanel(this.getCheckBox());
            }

            private JCheckBox getCheckBox() {
                this.checkBox = new JCheckBox("This is the step 1. Select the check box to be able to go to step 2");
                this.checkBox.addItemListener(this::checkBoxItemStateChanged);
                return this.checkBox;
            }

            private void checkBoxItemStateChanged(ItemEvent e) {
                WizardStepEvent event = new WizardStepEvent(this);
                if (this.checkBox.isSelected()) {
                    this.notifyWizardStepCompleted(event);
                } else {
                    this.notifyWizardStepUncompleted(event);
                }
            }

            @Override
            public void stepEntered() {
                System.err.println("Entered in step 1");
            }
        }, new WizardStep(){

            @Override
            public boolean isStepCompleted() {
                return true;
            }

            @Override
            public String getStepTitle() {
                return "Step 2";
            }

            @Override
            public JComponent getStepComponent() {
                return new CenteredJPanel(new JLabel("This is the step 2"));
            }

            @Override
            public void stepEntered() {
                System.err.println("Entered in step 2");
            }
        }, new WizardStep(){

            @Override
            public boolean isStepCompleted() {
                return true;
            }

            @Override
            public String getStepTitle() {
                return "Step 3";
            }

            @Override
            public JComponent getStepComponent() {
                return new CenteredJPanel(new JLabel("This is the final step!"));
            }

            @Override
            public void stepEntered() {
                System.err.println("Entered in step 3");
            }
        });
    }
}

