/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.math.statistical.tests;

import es.uvigo.ei.sing.math.ArrayUtils;
import es.uvigo.ei.sing.math.statistical.tests.AbstractTestOfIndependence;
import es.uvigo.ei.sing.math.statistical.tests.TestOfIndependence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.math3.stat.inference.TestUtils;

public class RandomizationTestOfIndependence
extends AbstractTestOfIndependence
implements TestOfIndependence {
    private static final long serialVersionUID = 1L;
    public static final String KEY_NUMBER_OF_THREADS = "peptideanalysis.toi.randomization.threads";
    public static final String KEY_NUMBER_OF_SIMULATIONS = "peptideanalysis.toi.randomization.simulations";
    public static final long DEFAULT_SEED = 133337L;
    public static final int DEFAULT_SIMULATIONS = 10000;
    private static final int SHUFFLE_TIMES = 20;
    private int simulations;
    private long seed;
    private int shuffleTimes;

    public RandomizationTestOfIndependence() {
        this(Integer.parseInt(System.getProperty(KEY_NUMBER_OF_SIMULATIONS, Integer.toString(10000))), 20, 133337L);
    }

    public RandomizationTestOfIndependence(int simulations) {
        this(simulations, 20, 133337L);
    }

    public RandomizationTestOfIndependence(int simulations, int shuffleTimes, long seed) {
        this.simulations = simulations;
        this.shuffleTimes = shuffleTimes;
        this.seed = seed;
    }

    public int getSimulations() {
        return this.simulations;
    }

    public void setSimulations(int simulations) {
        this.simulations = simulations;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public int getShuffleTimes() {
        return this.shuffleTimes;
    }

    public void setShuffleTimes(int shuffleTimes) {
        this.shuffleTimes = shuffleTimes;
    }

    @Override
    public double test(int[][] counts) throws InterruptedException {
        Random random = new Random(this.seed);
        double chiValue = TestUtils.chiSquare((long[][])ArrayUtils.intToLong(counts));
        ExecutorService executor = Executors.newFixedThreadPool(Integer.getInteger(KEY_NUMBER_OF_THREADS, 1));
        try {
            if (Double.isNaN(chiValue)) {
                return Double.NaN;
            }
            AtomicLong equalsOrGreaterCounter = new AtomicLong(0L);
            int i = 0;
            while (i < this.simulations) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                executor.execute(new TestTask(chiValue, equalsOrGreaterCounter, counts, this.shuffleTimes, random.nextLong()));
                ++i;
            }
            executor.shutdown();
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            double d = equalsOrGreaterCounter.doubleValue() / (double)this.simulations;
            return d;
        }
        finally {
            executor.shutdownNow();
        }
    }

    public static long[][] generateRandom(int[][] counts, int shuffleTimes, long seed) {
        if (Thread.interrupted()) {
            return null;
        }
        ArrayList<Boolean> presenceAbsence = new ArrayList<Boolean>();
        int i = 0;
        while (i < counts[0].length) {
            long j = 0L;
            while (j < (long)counts[0][i]) {
                presenceAbsence.add(Boolean.FALSE);
                ++j;
            }
            j = 0L;
            while (j < (long)counts[1][i]) {
                presenceAbsence.add(Boolean.TRUE);
                ++j;
            }
            ++i;
        }
        if (Thread.interrupted()) {
            return null;
        }
        Random shuffleRandom = new Random(seed);
        int i2 = 0;
        while (i2 < shuffleTimes) {
            Collections.shuffle(presenceAbsence, shuffleRandom);
            ++i2;
        }
        if (Thread.interrupted()) {
            return null;
        }
        long[][] randomCounts = new long[2][counts[0].length];
        int i3 = 0;
        while (i3 < counts[0].length) {
            long numSamples = counts[0][i3] + counts[1][i3];
            long j = 0L;
            while (j < numSamples) {
                Boolean isPresence = (Boolean)presenceAbsence.remove(presenceAbsence.size() - 1);
                long[] lArray = randomCounts[isPresence != false ? 1 : 0];
                int n = i3;
                lArray[n] = lArray[n] + 1L;
                ++j;
            }
            ++i3;
        }
        if (Thread.interrupted()) {
            return null;
        }
        return randomCounts;
    }

    private static final class TestTask
    implements Runnable {
        private final double chiValue;
        private final AtomicLong equalsOrGreaterCounter;
        private final int[][] counts;
        private final int shuffleTimes;
        private final long seed;

        public TestTask(double chiValue, AtomicLong equalsOrGreaterCounter, int[][] counts, int shuffleTimes, long seed) {
            this.chiValue = chiValue;
            this.equalsOrGreaterCounter = equalsOrGreaterCounter;
            this.counts = counts;
            this.shuffleTimes = shuffleTimes;
            this.seed = seed;
        }

        @Override
        public void run() {
            double randomChiValue;
            long[][] randomSamples = RandomizationTestOfIndependence.generateRandom(this.counts, this.shuffleTimes, this.seed);
            if (randomSamples != null && (randomChiValue = TestUtils.chiSquare((long[][])randomSamples)) >= this.chiValue) {
                this.equalsOrGreaterCounter.incrementAndGet();
            }
        }
    }
}

