/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.quantification;

import es.uvigo.ei.sing.s2p.core.entities.quantification.ProteinQuantification;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationDataset;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationReplicate;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationSample;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;

public class QuantificationReplicatesByProteinTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private static final int COLUMNS_PER_REPLICATE = 2;
    private static final String COL_QUANTIFICATION = "";
    private static final String COL_NORMALIZED_QUANTIFICATION = " [Normalized]";
    private QuantificationDataset dataset;
    private List<String> proteins;
    private List<QuantificationReplicate> replicates;
    private Map<QuantificationReplicate, String> replicatesConditions;
    private Map<QuantificationReplicate, String> replicatesNames;

    public QuantificationReplicatesByProteinTableModel(QuantificationDataset dataset) {
        this.dataset = dataset;
        this.createData();
    }

    private void createData() {
        this.proteins = new LinkedList<String>(this.dataset.getProteins());
        this.replicates = new LinkedList<QuantificationReplicate>();
        this.replicatesConditions = new HashMap<QuantificationReplicate, String>();
        this.replicatesNames = new HashMap<QuantificationReplicate, String>();
        for (QuantificationSample sample : this.dataset) {
            int replicatesCount = 1;
            for (QuantificationReplicate replicate : sample.getReplicates()) {
                this.replicates.add(replicate);
                if (sample.getCondition().isPresent()) {
                    this.replicatesConditions.put(replicate, (String)sample.getCondition().get());
                }
                this.replicatesNames.put(replicate, sample.getName() + " " + replicatesCount++);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.proteins == null ? 0 : this.proteins.size();
    }

    @Override
    public int getColumnCount() {
        return 1 + this.getReplicatesColumnCount();
    }

    private int getReplicatesColumnCount() {
        return this.replicates.size() * 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Protein";
        }
        return this.getColumnNameForReplicate(columnIndex);
    }

    private String getColumnNameForReplicate(int columnIndex) {
        String replicateName = this.replicatesNames.get(this.getReplicateAtIndex(columnIndex));
        int replicateColumn = this.getReplicateColumnIndex(columnIndex);
        if (replicateColumn == 0) {
            return replicateName + COL_QUANTIFICATION;
        }
        return replicateName + COL_NORMALIZED_QUANTIFICATION;
    }

    private QuantificationReplicate getReplicateAtIndex(int columnIndex) {
        return this.replicates.get(this.getReplicateIndex(columnIndex));
    }

    private int getReplicateIndex(int columnIndex) {
        return (columnIndex - 1) / 2;
    }

    private int getReplicateColumnIndex(int columnIndex) {
        return (columnIndex - 1) % 2;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String protein = this.proteins.get(rowIndex);
        if (columnIndex == 0) {
            return protein;
        }
        return this.getQuanfificationForReplicate(columnIndex, protein);
    }

    private Object getQuanfificationForReplicate(int columnIndex, String protein) {
        QuantificationReplicate replicate = this.getReplicateAtIndex(columnIndex);
        int replicateColumn = this.getReplicateColumnIndex(columnIndex);
        if (replicate.findProtein(protein).isPresent()) {
            ProteinQuantification pQ = (ProteinQuantification)replicate.findProtein(protein).get();
            if (replicateColumn == 0) {
                return pQ.getValue();
            }
            return pQ.getNormalizedValue();
        }
        return Double.NaN;
    }
}

