/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.hlfernandez.dialog;

import es.uvigo.ei.sing.hlfernandez.dialog.AbstractInputJDialog;
import es.uvigo.ei.sing.hlfernandez.filechooser.JFileChooserPanel;
import es.uvigo.ei.sing.hlfernandez.input.csv.CsvFormat;
import es.uvigo.ei.sing.hlfernandez.input.csv.CsvPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;

public class ExportCsvDialog
extends AbstractInputJDialog {
    private static final long serialVersionUID = 1L;
    private static final String TITLE = "Export to CSV";
    private static final String DESCRIPTION = "This dialog allows you to export the data as a CSV file(s). You can select a preconfigured format (Excel, Libre/Open Office) or Custom to customize it.";
    private CsvPanel csvPanel;
    private JFileChooserPanel fileChooserPanel;

    public ExportCsvDialog(Window parent) {
        super(parent);
        this.pack();
    }

    @Override
    protected String getDialogTitle() {
        return TITLE;
    }

    @Override
    protected String getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected JPanel getInputComponentsPane() {
        this.csvPanel = new CsvPanel();
        this.csvPanel.addCsvListener(this::onChangeEvent);
        JPanel inputComponents = new JPanel(new BorderLayout());
        inputComponents.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        inputComponents.add(this.getFileChooserComponent(), "North");
        inputComponents.add((Component)this.csvPanel, "Center");
        return inputComponents;
    }

    private Component getFileChooserComponent() {
        JPanel fileChooserComponent = new JPanel(new BorderLayout());
        fileChooserComponent.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 5));
        this.fileChooserPanel = new JFileChooserPanel(JFileChooserPanel.Mode.SAVE, this.getFileChooser(), "csv");
        this.fileChooserPanel.addFileChooserListener(this::onChangeEvent);
        JLabel help = new JLabel(ICON_HELP);
        help.setToolTipText("The file to save the data");
        help.setBorder(BorderFactory.createEmptyBorder(0, 14, 0, 7));
        fileChooserComponent.add((Component)this.fileChooserPanel, "Center");
        fileChooserComponent.add((Component)help, "East");
        return fileChooserComponent;
    }

    private void onChangeEvent(ChangeEvent e) {
        this.checkOkButton();
    }

    private void checkOkButton() {
        this.okButton.setEnabled(this.csvPanel.isValidFormat() && this.isSelectedFileValid());
        this.pack();
    }

    private boolean isSelectedFileValid() {
        return this.fileChooserPanel.getSelectedFile() != null && !this.fileChooserPanel.getSelectedFile().equals("");
    }

    public File getSelectedFile() {
        return this.fileChooserPanel.getSelectedFile();
    }

    public CsvFormat getSelectedCsvFormat() {
        return this.csvPanel.getCsvFormat();
    }

    public void setSelectedCsvFileFormat(CsvFormat.FileFormat format) {
        this.csvPanel.setSelectedCsvFileFormat(format);
    }
}

