/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.inputgui;

import es.uvigo.ei.aibench.core.ParamSource;
import es.uvigo.ei.aibench.core.ParamSpec;
import es.uvigo.ei.aibench.core.operation.annotation.Port;
import es.uvigo.ei.aibench.workbench.ParamsReceiver;
import es.uvigo.ei.aibench.workbench.inputgui.AbstractParamProvider;
import es.uvigo.ei.aibench.workbench.utilities.PortExtras;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.log4j.Logger;

public class EnumParamProvider
extends AbstractParamProvider {
    private static final Logger LOGGER = Logger.getLogger(EnumParamProvider.class);
    public static final String PROPERTY_MODE = "mode";
    public static final String PROPERTY_MODE_COMBO = "combo";
    public static final String PROPERTY_MODE_BUTTONS = "radiobuttons";
    public static final String PROPERTY_BUTTONS_ROWS = "numrows";
    public static final String PROPERTY_BUTTONS_COLUMNS = "numcolumns";
    private static final String[] KNOWN_PROPERTIES = new String[]{"mode", "numrows", "numcolumns"};
    public static final int DEFAULT_NUM_ROWS = 0;
    public static final int DEFAULT_NUM_COLUMNS = 1;
    private String mode = "combo";
    private JComboBox<Object> combo = new JComboBox();
    private ButtonGroup group = new ButtonGroup();
    private JPanel buttonsPanel;
    private int buttonsPanelRows = 0;
    private int buttonsPanelColumns = 1;

    public EnumParamProvider(ParamsReceiver receiver, Port p, Class<?> clazz, Object operationObject) {
        super(receiver, p, clazz, operationObject);
        this.initComponent();
    }

    private void initComponent() {
        this.parseExtras();
        if (this.isComboMode()) {
            this.createCombobox();
        } else {
            this.createRadioButtons();
        }
    }

    private void createCombobox() {
        for (Object o : this.clazz.getEnumConstants()) {
            this.combo.addItem(o);
            if (this.port.defaultValue().equals(o.toString())) {
                this.combo.setSelectedItem(o);
            }
            this.combo.addActionListener(this);
            this.combo.addKeyListener(this);
        }
    }

    private void createRadioButtons() {
        this.buttonsPanel = new JPanel(new GridLayout(this.buttonsPanelRows, this.buttonsPanelColumns));
        for (Object o : this.clazz.getEnumConstants()) {
            JRadioButton button = new JRadioButton(o.toString());
            button.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EnumParamProvider.this.actionPerformed(null);
                }
            });
            this.group.add(button);
            this.buttonsPanel.add(button);
            if (!this.port.defaultValue().equals(o.toString())) continue;
            button.setSelected(true);
        }
    }

    private boolean isComboMode() {
        return this.mode.equalsIgnoreCase(PROPERTY_MODE_COMBO);
    }

    private void parseExtras() {
        PortExtras extras = PortExtras.parse(this.port.extras());
        if (extras.containsProperty(PROPERTY_MODE)) {
            String mode = extras.getPropertyValue(PROPERTY_MODE);
            if (mode.equalsIgnoreCase(PROPERTY_MODE_BUTTONS) || mode.equalsIgnoreCase(PROPERTY_MODE_COMBO)) {
                this.mode = mode;
            } else {
                LOGGER.warn((Object)("Unknown mode property: " + mode + ". Using default mode: " + PROPERTY_MODE_COMBO));
            }
        }
        if (!this.isComboMode()) {
            if (extras.containsProperty(PROPERTY_BUTTONS_ROWS)) {
                String rows = extras.getPropertyValue(PROPERTY_BUTTONS_ROWS);
                try {
                    this.buttonsPanelRows = Integer.valueOf(rows);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("Invalid numrows property: " + rows + ". It must be an integer."));
                }
            }
            if (extras.containsProperty(PROPERTY_BUTTONS_COLUMNS)) {
                String columns = extras.getPropertyValue(PROPERTY_BUTTONS_COLUMNS);
                try {
                    this.buttonsPanelColumns = Integer.valueOf(columns);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("Invalid numcolumns property: " + columns + ". It must be an integer."));
                }
            }
            if (this.buttonsPanelRows == 0 && this.buttonsPanelColumns == 0) {
                this.buttonsPanelRows = 0;
                this.buttonsPanelColumns = 1;
                LOGGER.warn((Object)"Warning: numrows and numcolumns cannot both be zero. Using default values instead.");
            }
        }
        PortExtras.warnUnknownExtraProperties(extras, LOGGER, true, KNOWN_PROPERTIES);
    }

    @Override
    public JComponent getComponent() {
        return this.isComboMode() ? this.combo : this.buttonsPanel;
    }

    @Override
    public ParamSpec getParamSpec() {
        return new ParamSpec(this.port.name(), this.clazz, this.getSelectedItem(), ParamSource.ENUM);
    }

    private Object getSelectedItem() {
        return this.isComboMode() ? this.getSelectedComboItem() : this.getSelectedRadioItem();
    }

    private Object getSelectedComboItem() {
        return this.combo.getSelectedItem();
    }

    private Object getSelectedRadioItem() {
        int i = 0;
        Enumeration<AbstractButton> buttons = this.group.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (button.isSelected()) {
                return this.clazz.getEnumConstants()[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isValidValue() {
        if (!this.port.allowNull()) {
            return this.getSelectedItem() != null;
        }
        return true;
    }
}

