/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class Util {
    public static File urlToFile(URL url) {
        return Util.urlToFile(url, false);
    }

    public static File urlToFile(URL url, boolean usePath) {
        try {
            return new File(url.toURI());
        }
        catch (Exception e) {
            return new File(usePath ? url.getPath() : url.getFile());
        }
    }

    public static URL getGlobalResourceURL(String resourcePath) {
        try {
            URL url = Util.class.getProtectionDomain().getCodeSource().getLocation();
            try {
                url = url.getFile().endsWith(".jar") ? new URL(url.toString().substring(0, url.toString().lastIndexOf(47)) + "/../" + resourcePath) : new URL(url + "../" + resourcePath);
                if (!new File(url.getFile()).exists()) {
                    File fallbackFile = new File(resourcePath);
                    if (!fallbackFile.exists()) {
                        throw new IllegalArgumentException("cannot find global resource " + resourcePath);
                    }
                    return fallbackFile.toURI().toURL();
                }
                return url;
            }
            catch (MalformedURLException e1) {
                throw new RuntimeException("Not found a aibench configuration file, searching in url: " + url.getFile(), e1);
            }
        }
        catch (NullPointerException e) {
            try {
                return new File(resourcePath).toURI().toURL();
            }
            catch (Exception e1) {
                throw new RuntimeException("Can't find resource in path " + resourcePath + " due to " + e1, e1);
            }
        }
    }
}

