/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.pipespecification.storage;

import es.uvigo.ei.aibench.core.operation.execution.IncompatibleConstraintsException;
import es.uvigo.ei.pipespecification.storage.CompositedPipeDefinitionLoader;
import es.uvigo.ei.pipespecification.storage.IncludeDefinitionLoader;
import es.uvigo.ei.pipespecification.storage.InvalidAnnotationsFormatException;
import es.uvigo.ei.pipespecification.storage.Parallelizer;
import es.uvigo.ei.pipespecification.storage.PipeDefinition;
import es.uvigo.ei.pipespecification.storage.SimplePipeDefinitionLoader;
import es.uvigo.ei.pipespecification.storage.TeeDefinitionLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

abstract class PipeDefinitionLoader {
    private static Map<String, PipeDefinitionLoader> definitionLoadersMap;

    PipeDefinitionLoader() {
    }

    private static void addLoader(PipeDefinitionLoader loader1) {
        definitionLoadersMap.put(loader1.getElementName(), loader1);
    }

    static PipeDefinition load(Element element, File file, Map<String, Class<?>> argumentsSpecificationContext) throws IncompatibleConstraintsException, InvalidAnnotationsFormatException, ClassNotFoundException, SAXException, IOException {
        if (definitionLoadersMap.containsKey(element.getLocalName())) {
            return definitionLoadersMap.get(element.getLocalName()).loadFromElement(element, file, argumentsSpecificationContext);
        }
        throw new IllegalArgumentException("The element " + element + " is unsupported");
    }

    static List<Element> getPipeDefinitionElements(NodeList nodeList) {
        List<Element> elements = PipeDefinitionLoader.getElements(nodeList);
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element element : elements) {
            if (!definitionLoadersMap.containsKey(element.getLocalName())) continue;
            result.add(element);
        }
        return result;
    }

    protected static List<Element> getElements(NodeList childNodes) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            elements.add((Element)node);
        }
        return elements;
    }

    abstract String getElementName();

    abstract PipeDefinition loadFromElement(Element var1, File var2, Map<String, Class<?>> var3) throws IncompatibleConstraintsException, InvalidAnnotationsFormatException, ClassNotFoundException, SAXException, IOException;

    static {
        PipeDefinitionLoader[] loaders;
        definitionLoadersMap = new HashMap<String, PipeDefinitionLoader>();
        for (PipeDefinitionLoader loader : loaders = new PipeDefinitionLoader[]{new SimplePipeDefinitionLoader(), new CompositedPipeDefinitionLoader(), new TeeDefinitionLoader(), new IncludeDefinitionLoader(), new Parallelizer()}) {
            PipeDefinitionLoader.addLoader(loader);
        }
    }
}

