/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.entities;

import java.util.List;

public class SpotSummary {
    private int numSamples;
    private int totalSamples;
    private double mean;
    private double std;
    private List<Double> spotValues;

    public SpotSummary(int numSamples, int totalSamples, double mean, double std, List<Double> spotValues) {
        this.numSamples = numSamples;
        this.totalSamples = totalSamples;
        this.mean = mean;
        this.std = std;
        this.spotValues = spotValues;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public int getTotalSamples() {
        return this.totalSamples;
    }

    public double getPop() {
        return 100.0 * (double)this.getNumSamples() / (double)this.getTotalSamples();
    }

    public double getMean() {
        return this.mean;
    }

    public double getStdDev() {
        return this.std;
    }

    public List<Double> getSpotValues() {
        return this.spotValues;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[SpotSummary] Total = ").append(this.getTotalSamples()).append(" | Spots = ").append(this.getNumSamples()).append(" | Mean = ").append(this.getMean()).append(" | Std = ").append(this.getStdDev()).append(" | POP = ").append(this.getPop());
        return sb.toString();
    }
}

