/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.entities;

import com.itextpdf.text.DocumentException;
import es.uvigo.ei.sing.commons.csv.entities.CsvData;
import es.uvigo.ei.sing.commons.csv.entities.CsvEntry;
import es.uvigo.ei.sing.s2p.core.entities.MaldiPlateInformation;
import es.uvigo.ei.sing.s2p.core.io.MaldiPlateWriter;
import es.uvigo.ei.sing.s2p.core.util.Checks;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MaldiPlate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String[][] data;
    private List<String> colNames;
    private List<String> rowNames;
    private MaldiPlateInformation info = new MaldiPlateInformation();

    public MaldiPlate(CsvData csvData) {
        this.colNames = (List)csvData.remove(0);
        this.colNames.remove(0);
        this.rowNames = new LinkedList<String>();
        csvData.forEach(e -> this.rowNames.add((String)e.remove(0)));
        this.data = new String[this.rowNames.size()][this.colNames.size()];
        for (int i = 0; i < this.rowNames.size(); ++i) {
            this.data[i] = ((CsvEntry)csvData.get(i)).toArray();
        }
    }

    public MaldiPlate(MaldiPlate plate) {
        this(plate.getRowNames(), plate.getColNames(), plate.getData(), plate.getInfo());
    }

    public MaldiPlate(List<String> rowNames, List<String> colNames, String[][] data, MaldiPlateInformation info) {
        this.rowNames = rowNames;
        this.colNames = colNames;
        this.data = data;
        this.info = info;
    }

    public MaldiPlate(int rows, int cols, Positions rowsPositions, Positions columnsPositions) {
        this.initData(Checks.requireStrictPositive(rows, "Number of rows must be greater than 0"), Checks.requireStrictPositive(cols, "Number of columns must be greater than 0"), rowsPositions, columnsPositions);
    }

    private void initData(int rows, int cols, Positions rowsPositions, Positions columnsPositions) {
        this.rowNames = rowsPositions.generatePositions(rows);
        this.colNames = columnsPositions.generatePositions(cols);
        this.data = new String[rows][cols];
    }

    private static String str(int i) {
        return i < 0 ? "" : MaldiPlate.str(i / 26 - 1) + (char)(65 + i % 26);
    }

    public void addCalibrants() {
        int cal = 1;
        for (int i = 1; i < this.rowNames.size(); i += 3) {
            for (int j = 1; j < this.colNames.size(); j += 3) {
                this.data[i][j] = "Cal " + cal++;
            }
        }
    }

    public String[][] getData() {
        return this.data;
    }

    public void setData(String[][] data) {
        this.data = data;
    }

    public List<String> getRowNames() {
        return this.rowNames;
    }

    public List<String> getColNames() {
        return this.colNames;
    }

    public MaldiPlateInformation getInfo() {
        return this.info;
    }

    public void setInfo(MaldiPlateInformation info) {
        this.info = info;
    }

    public Map<String, String> asMap() {
        HashMap<String, String> toret = new HashMap<String, String>();
        for (int i = 0; i < this.rowNames.size(); ++i) {
            for (int j = 0; j < this.colNames.size(); ++j) {
                String cellValue = this.data[i][j];
                if (cellValue == null || cellValue.equals("")) continue;
                toret.put(this.cell(i, j), cellValue);
            }
        }
        return toret;
    }

    private String cell(int row, int col) {
        return this.rowNames.get(row) + this.colNames.get(col);
    }

    public void toPdf(File file) throws FileNotFoundException, DocumentException {
        MaldiPlateWriter.toPdf(this, file);
    }

    public void toFile(File file) throws IOException {
        MaldiPlateWriter.toFile(this, file);
    }

    public static enum Positions {
        LETTERS("A, B, C, ..."),
        NUMBERS("1, 2, 3, ...");

        private String description;

        private Positions(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public List<String> generatePositions(int length) {
            if (this.equals((Object)LETTERS)) {
                return IntStream.range(0, length).boxed().map(x$0 -> MaldiPlate.str(x$0)).collect(Collectors.toList());
            }
            return IntStream.rangeClosed(1, length).boxed().map(String::valueOf).collect(Collectors.toList());
        }
    }
}

