/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.demo;

import java.awt.Component;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.sing_group.gc4s.demo.DemoUtils;
import org.sing_group.gc4s.input.DoubleRange;
import org.sing_group.gc4s.visualization.JHeatMap;
import org.sing_group.gc4s.visualization.JHeatMapModel;
import org.sing_group.gc4s.visualization.JHeatMapPanel;

public class JHeatMapDemo {
    public static void main(String[] args) {
        double[][] data = new double[][]{{1.0, 2.0, 3.0, 4.0, Double.NaN}, {1.1, 2.1, 3.1, 4.1, 5.1}, {1.2, 2.2, 3.2, 4.2, 5.2}, {1.3, 2.3, 3.3, 4.3, 5.3}, {1.4, 2.4, 3.4, 4.4, 5.4}};
        JHeatMap heatmap = new JHeatMap(new JHeatMapModel(data, JHeatMapDemo.generateRowNames(data), JHeatMapDemo.generateColumnNames(data)));
        heatmap.setValuesRange(new DoubleRange(0.0, 7.0));
        DemoUtils.showComponent((Component)new JHeatMapPanel(heatmap), "JHeatMap demo");
    }

    private static String[] generateRowNames(double[][] data) {
        List<String> rownames = IntStream.range(0, data.length).mapToObj(String::valueOf).map(s -> new String("R" + s)).collect(Collectors.toList());
        return rownames.toArray(new String[rownames.size()]);
    }

    private static String[] generateColumnNames(double[][] data) {
        List<String> colnames = IntStream.range(0, data[0].length).mapToObj(String::valueOf).map(s -> new String("Column " + s)).collect(Collectors.toList());
        return colnames.toArray(new String[colnames.size()]);
    }
}

