/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.quantification;

import es.uvigo.ei.sing.s2p.core.entities.quantification.ProteinQuantification;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationCondition;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationConditionsComparison;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationConditionsComparisons;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationDataset;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationReplicate;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationSample;
import es.uvigo.ei.sing.s2p.core.operations.quantification.comparison.ProteinSummaryTest;
import es.uvigo.ei.sing.s2p.core.operations.quantification.comparison.QuantificationsConditionsTest;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class QuantificationTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private static final int COLUMNS_PER_COMPARISON = 2;
    private static final int COLUMNS_PER_SAMPLE = 9;
    private static final int SAMPLE_PQ_MEAN = 0;
    private static final int SAMPLE_PQ_STD = 1;
    private static final int SAMPLE_PQ_RSD = 2;
    private static final int SAMPLE_NORMALIZED_PQ_MEAN = 3;
    private static final int SAMPLE_NORMALIZED_PQ_STD = 4;
    private static final int SAMPLE_NORMALIZED_PQ_RSD = 5;
    private static final int SAMPLE_MASS_MEAN = 6;
    private static final int SAMPLE_MASS_STD = 7;
    private static final int SAMPLE_POP = 8;
    private static final Function<DescriptiveStatistics, Double> MEAN = DescriptiveStatistics::getMean;
    private static final Function<DescriptiveStatistics, Double> STD = DescriptiveStatistics::getStandardDeviation;
    private static final Function<DescriptiveStatistics, Double> RSD = d -> d.getStandardDeviation() / d.getMean();
    private static final BiFunction<QuantificationSample, ProteinQuantification, Double> PROTEIN_MASS = (s, pQ) -> s.getProteinMass() * pQ.getNormalizedValue();
    private List<String> allProteins;
    private QuantificationDataset dataset;
    private QuantificationConditionsComparisons conditionsComparisons;
    private ProteinSummaryTest proteinComparison;

    public QuantificationTableModel(QuantificationDataset dataset, ProteinSummaryTest proteinComparison) {
        this.dataset = dataset;
        this.proteinComparison = proteinComparison;
        this.createData();
    }

    private void createData() {
        this.allProteins = new LinkedList<String>(this.getAllDatasetProteins());
        this.conditionsComparisons = QuantificationsConditionsTest.compare((QuantificationDataset)this.dataset, (ProteinSummaryTest)this.proteinComparison);
    }

    private Set<String> getAllDatasetProteins() {
        return this.dataset.stream().map(QuantificationSample::getReplicates).flatMap(Collection::stream).map(QuantificationReplicate::getProteins).flatMap(Collection::stream).map(ProteinQuantification::getProtein).distinct().collect(Collectors.toSet());
    }

    @Override
    public int getRowCount() {
        return this.allProteins == null ? 0 : this.allProteins.size();
    }

    @Override
    public int getColumnCount() {
        return 1 + this.getSampleColumnsCount() + this.getComparisonColumnsCount();
    }

    private int getSampleColumnsCount() {
        return this.dataset.size() * 9;
    }

    private int getComparisonColumnsCount() {
        return this.getConditionComparisonsCount() * 2;
    }

    private int getConditionComparisonsCount() {
        return this.conditionsComparisons.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Protein";
        }
        if (this.isSampleColumn(columnIndex)) {
            return this.getSampleColumnName(columnIndex);
        }
        return this.getComparisonColumnName(columnIndex);
    }

    private boolean isSampleColumn(int columnIndex) {
        int sampleIndex = this.getSampleIndex(columnIndex);
        return columnIndex != 0 && sampleIndex < this.dataset.size();
    }

    private int getSampleIndex(int columnIndex) {
        return (columnIndex - 1) / 9;
    }

    private String getSampleColumnName(int columnIndex) {
        int sampleIndex = this.getSampleIndex(columnIndex);
        QuantificationSample sample = (QuantificationSample)this.dataset.get(sampleIndex);
        int sampleColumnIndex = this.getSampleInformationColumnIndex(columnIndex);
        String condition = "";
        if (this.getConditionNameAt(columnIndex).isPresent()) {
            condition = " (" + this.getConditionNameAt(columnIndex).get() + ")";
        }
        switch (sampleColumnIndex) {
            case 0: {
                return sample.getName() + " [mean PQ]" + condition;
            }
            case 1: {
                return sample.getName() + " [std PQ]" + condition;
            }
            case 2: {
                return sample.getName() + " [rsd PQ]" + condition;
            }
            case 3: {
                return sample.getName() + " [mean normalized PQ]" + condition;
            }
            case 4: {
                return sample.getName() + " [std normalized PQ]" + condition;
            }
            case 5: {
                return sample.getName() + " [rsd normalized PQ]" + condition;
            }
            case 6: {
                return sample.getName() + " [mean mass]" + condition;
            }
            case 7: {
                return sample.getName() + " [std mass]" + condition;
            }
            case 8: {
                return sample.getName() + " [POP]" + condition;
            }
        }
        throw new IllegalStateException();
    }

    private int getSampleInformationColumnIndex(int columnIndex) {
        return (columnIndex - 1) % 9;
    }

    private String getComparisonColumnName(int columnIndex) {
        int comparisonIndex = this.getComparisonIndex(columnIndex);
        String comparisonColunnName = ((QuantificationConditionsComparison)this.conditionsComparisons.get(comparisonIndex)).toString();
        int comparisonColumnIndex = this.getComparisonColumnIndex(columnIndex);
        switch (comparisonColumnIndex) {
            case 0: {
                comparisonColunnName = comparisonColunnName + " [p-val]";
                break;
            }
            case 1: {
                comparisonColunnName = comparisonColunnName + " [q-val]";
            }
        }
        return comparisonColunnName;
    }

    private int getComparisonColumnIndex(int columnIndex) {
        return this.toComparisonColumnRange(columnIndex) % 2;
    }

    private int toComparisonColumnRange(int columnIndex) {
        return columnIndex - (1 + this.getSampleColumnsCount());
    }

    private int getComparisonIndex(int columnIndex) {
        return this.toComparisonColumnRange(columnIndex) / 2;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String protein = this.allProteins.get(rowIndex);
        if (columnIndex == 0) {
            return protein;
        }
        if (this.isSampleColumn(columnIndex)) {
            return this.getSampleValuesForProtein(protein, columnIndex);
        }
        return this.getComparisonValueForProtein(protein, columnIndex);
    }

    private Object getSampleValuesForProtein(String protein, int columnIndex) {
        int sampleIndex = this.getSampleIndex(columnIndex);
        QuantificationSample sample = (QuantificationSample)this.dataset.get(sampleIndex);
        int sampleColumnIndex = (columnIndex - 1) % 9;
        switch (sampleColumnIndex) {
            case 0: {
                return this.getValue(sample, protein, MEAN, ProteinQuantification::getValue);
            }
            case 1: {
                return this.getValue(sample, protein, STD, ProteinQuantification::getValue);
            }
            case 2: {
                return this.getValue(sample, protein, RSD, ProteinQuantification::getValue);
            }
            case 3: {
                return this.getValue(sample, protein, MEAN, ProteinQuantification::getNormalizedValue);
            }
            case 4: {
                return this.getValue(sample, protein, STD, ProteinQuantification::getNormalizedValue);
            }
            case 5: {
                return this.getValue(sample, protein, RSD, ProteinQuantification::getNormalizedValue);
            }
            case 6: {
                return this.getValue(sample, protein, MEAN, pQ -> PROTEIN_MASS.apply(sample, (ProteinQuantification)pQ));
            }
            case 7: {
                return this.getValue(sample, protein, STD, pQ -> PROTEIN_MASS.apply(sample, (ProteinQuantification)pQ));
            }
            case 8: {
                return this.getProteinPop(sample, protein);
            }
        }
        throw new IllegalStateException();
    }

    private Stream<ProteinQuantification> getProteinQuantifications(QuantificationSample sample, String protein) {
        return sample.getReplicates().stream().map(QuantificationReplicate::getProteins).flatMap(Collection::stream).filter(p -> p.getProtein().equals(protein));
    }

    public double getValue(QuantificationSample sample, String protein, Function<DescriptiveStatistics, Double> collect, Function<ProteinQuantification, Double> map) {
        DescriptiveStatistics statistics = new DescriptiveStatistics();
        this.getProteinQuantifications(sample, protein).map(map::apply).forEach(v -> statistics.addValue(v.doubleValue()));
        return collect.apply(statistics);
    }

    public String getProteinPop(QuantificationSample sample, String protein) {
        int count = 0;
        int total = 0;
        for (QuantificationReplicate r : sample.getReplicates()) {
            ++total;
            if (!r.findProtein(protein).isPresent()) continue;
            ++count;
        }
        return count + "/" + total;
    }

    public Optional<QuantificationCondition> getConditionAt(int columnModel) {
        Optional<String> conditionName = this.getConditionNameAt(columnModel);
        if (conditionName.isPresent()) {
            return this.dataset.getConditions().stream().filter(c -> c.getName().equals(conditionName.get())).findAny();
        }
        return Optional.empty();
    }

    private Object getComparisonValueForProtein(String protein, int columnIndex) {
        int comparisonIndex = this.getComparisonIndex(columnIndex);
        int comparisonColumnIndex = this.getComparisonColumnIndex(columnIndex);
        QuantificationConditionsComparison comparison = (QuantificationConditionsComparison)this.conditionsComparisons.get(comparisonIndex);
        switch (comparisonColumnIndex) {
            case 0: {
                return comparison.getProteinPvalues().getOrDefault(protein, Double.NaN);
            }
            case 1: {
                return comparison.getProteinQvalues().getOrDefault(protein, Double.NaN);
            }
        }
        throw new IllegalStateException();
    }

    public Optional<String> getConditionNameAt(int columnModel) {
        if (this.isSampleColumn(columnModel)) {
            int sampleIndex = this.getSampleIndex(columnModel);
            return ((QuantificationSample)this.dataset.get(sampleIndex)).getCondition();
        }
        return Optional.empty();
    }

    public String getProteinAt(int rowModel) {
        return this.allProteins.get(rowModel);
    }
}

