/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.quantification;

import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationDataset;
import es.uvigo.ei.sing.s2p.gui.quantification.QuantificationReplicatesByProteinTableModel;
import es.uvigo.ei.sing.s2p.gui.table.ExtendedCsvTable;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;

public class QuantificationReplicatesByProteinTable
extends ExtendedCsvTable {
    private static final long serialVersionUID = 1L;

    public QuantificationReplicatesByProteinTable(QuantificationDataset dataset) {
        super(new QuantificationReplicatesByProteinTableModel(dataset));
        this.initComponent();
    }

    private void initComponent() {
        this.addExportToCsvAction();
        QuantificationReplicatesTableCellRenderer renderer = new QuantificationReplicatesTableCellRenderer();
        this.setDefaultRenderer(Double.class, (TableCellRenderer)((Object)renderer));
        this.setHorizontalScrollEnabled(true);
        this.packAll();
    }

    private class QuantificationReplicatesTableCellRenderer
    extends DefaultTableRenderer {
        private static final long serialVersionUID = 1L;

        private QuantificationReplicatesTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel label = (JLabel)c;
            if (!(value instanceof String)) {
                String cellValue;
                Double doubleValue = Double.parseDouble(value.toString());
                String string = cellValue = Double.isNaN(doubleValue) ? "" : String.format("%6.2e", doubleValue);
                if (!cellValue.isEmpty()) {
                    label.setToolTipText(doubleValue.toString());
                }
                label.setText(cellValue);
            }
            return c;
        }
    }
}

