/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.utilities;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PortExtras {
    public static final String EXTRAS_DELIMITER = ",";
    public static final String EXTRAS_ASSIGNMENT = "=";
    private static final Logger LOG = Logger.getLogger(PortExtras.class);
    private Map<String, String> extras;

    public PortExtras(Map<String, String> extras) {
        this.extras = extras;
    }

    public static PortExtras parse(String extrasString) {
        HashMap<String, String> extras = new HashMap<String, String>();
        if (extrasString != null && !extrasString.trim().isEmpty()) {
            String[] props;
            for (String prop : props = extrasString.split(EXTRAS_DELIMITER)) {
                String property;
                String[] propValue = prop.trim().split(EXTRAS_ASSIGNMENT);
                if (propValue.length == 2) {
                    property = propValue[0].trim();
                    String value = propValue[1].trim();
                    PortExtras.addProperty(extras, prop, property, value);
                    continue;
                }
                if (propValue.length == 1) {
                    property = propValue[0].trim();
                    PortExtras.addProperty(extras, prop, property, "");
                    continue;
                }
                LOG.warn((Object)("Unable to parse a property in extras: " + prop));
            }
        }
        return new PortExtras(extras);
    }

    private static void addProperty(Map<String, String> extras, String prop, String property, String value) {
        if (extras.containsKey(property)) {
            LOG.warn((Object)("Ignoring duplicated property in extras: " + prop));
        } else {
            extras.put(property, value);
        }
    }

    public Set<String> getProperties() {
        return this.extras.keySet();
    }

    public String getPropertyValue(String property) {
        return this.extras.get(property);
    }

    public boolean containsProperty(String property) {
        return this.containsProperty(property, true);
    }

    public boolean containsProperty(String property, boolean ignoreCase) {
        return ignoreCase ? this.containsPropertyIgnoreCase(property) : this.extras.containsKey(property);
    }

    private boolean containsPropertyIgnoreCase(String property) {
        for (String p : this.getProperties()) {
            if (!p.equalsIgnoreCase(property)) continue;
            return true;
        }
        return false;
    }

    public static void warnUnknownExtraProperties(PortExtras extras, Logger logger, boolean ignoreCase, String ... knownProperties) {
        for (String property : extras.getProperties()) {
            boolean known = false;
            for (String knownProprety : knownProperties) {
                if (!PortExtras.equals(property, knownProprety, ignoreCase)) continue;
                known = true;
            }
            if (known) continue;
            logger.warn((Object)("Unknown extra property: " + property));
        }
    }

    private static boolean equals(String a, String b, boolean ignoreCase) {
        return ignoreCase ? a.equalsIgnoreCase(b) : a.equals(b);
    }
}

