/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.spots.summary;

import es.uvigo.ei.sing.s2p.core.entities.Condition;
import es.uvigo.ei.sing.s2p.core.entities.SpotMascotIdentifications;
import es.uvigo.ei.sing.s2p.core.entities.SpotSummary;
import es.uvigo.ei.sing.s2p.core.entities.SpotsData;
import es.uvigo.ei.sing.s2p.gui.UISettings;
import es.uvigo.ei.sing.s2p.gui.charts.spots.ChartSpotSummary;
import es.uvigo.ei.sing.s2p.gui.charts.spots.SpotsSummaryChartDialog;
import es.uvigo.ei.sing.s2p.gui.spots.SpotUtils;
import es.uvigo.ei.sing.s2p.gui.spots.summary.ConditionsSummaryTableModel;
import es.uvigo.ei.sing.s2p.gui.table.ExtendedCsvTable;
import es.uvigo.ei.sing.s2p.gui.table.TestRowFilter;
import es.uvigo.ei.sing.s2p.gui.table.spots.ConditionControlAction;
import es.uvigo.ei.sing.s2p.gui.table.spots.SpotPresenceTester;
import es.uvigo.ei.sing.s2p.gui.table.spots.SpotsCsvTable;
import es.uvigo.ei.sing.s2p.gui.util.ColorUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;

public class ConditionsSummaryTable
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ExtendedCsvTable table;
    private ConditionsSummaryTableModel tableModel;
    private SpotsData data;
    private Map<Condition, Color> conditionsColors;
    private SpotPresenceTester spotPresenceTester;
    private boolean showProteinIdentifications = false;
    private Optional<SpotMascotIdentifications> mascotIdentifications = Optional.empty();

    public ConditionsSummaryTable(SpotsData data) {
        this.data = data;
        this.initComponent();
    }

    private void initComponent() {
        this.initColors();
        this.setLayout(new BorderLayout());
        this.setBackground(UISettings.BG_COLOR);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)new JScrollPane(this.getTable()), "Center");
    }

    private void initColors() {
        this.conditionsColors = new HashMap<Condition, Color>();
        for (Condition c : this.getConditions()) {
            Color conditionColor = ColorUtils.getSoftColor(this.getConditions().indexOf(c));
            this.conditionsColors.put(c, conditionColor);
        }
    }

    private List<Condition> getConditions() {
        return this.data.getConditions();
    }

    private Component getTable() {
        if (this.table == null) {
            this.tableModel = new ConditionsSummaryTableModel(this.data);
            this.table = new SpotsCsvTable((TableModel)this.tableModel, this::getSpotValue);
            ConditionsSummaryTableCellRenderer renderer = new ConditionsSummaryTableCellRenderer();
            this.table.setDefaultRenderer(String.class, (TableCellRenderer)((Object)renderer));
            this.table.setDefaultRenderer(Double.class, (TableCellRenderer)((Object)renderer));
            this.table.getTableHeader().setDefaultRenderer(new ConditionsSummaryTableHeaderCellRenderer(this.table.getTableHeader().getDefaultRenderer()));
            this.table.getTableHeader().setReorderingAllowed(false);
            this.table.addExportToCsvAction();
            this.createHideConditionsActions();
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JTable table = (JTable)e.getSource();
                    Point p = e.getPoint();
                    int row = table.rowAtPoint(p);
                    if (e.getClickCount() == 2 && row != -1) {
                        ConditionsSummaryTable.this.viewSpotAtRow(table.convertRowIndexToModel(row));
                    }
                }
            });
            this.spotPresenceTester = new SpotPresenceTester(this.getSpots());
            this.table.setRowFilter(new TestRowFilter(this.spotPresenceTester, 0));
        }
        return this.table;
    }

    private void createHideConditionsActions() {
        this.getConditions().forEach(c -> this.table.addAction(this.getHideConditionAction((Condition)c)));
    }

    private Action getHideConditionAction(Condition c) {
        return new ConditionControlAction(c, this::setConditionVisibility);
    }

    private void setConditionVisibility(Condition c, boolean visible) {
        int conditionIndex = this.getConditions().indexOf(c) * 4 + 1;
        List<Integer> columnIndices = IntStream.range(conditionIndex, conditionIndex + 4).boxed().collect(Collectors.toList());
        this.table.setColumnsVisibility(columnIndices, visible);
    }

    private String getSpotValue(String spot) {
        return SpotUtils.spotValue(spot, this.showProteinIdentifications, this.mascotIdentifications);
    }

    private Set<String> getSpots() {
        return new HashSet<String>(this.data.getSpots());
    }

    private void viewSpotAtRow(int row) {
        String spot = this.tableModel.getSpotAt(row);
        LinkedList<ChartSpotSummary> summaries = new LinkedList<ChartSpotSummary>();
        this.data.getConditions().forEach(c -> summaries.add(new ChartSpotSummary(this.tableModel.getSpotSummary(spot, (Condition)c), c.getName(), this.conditionsColors.get(c))));
        SpotsSummaryChartDialog dialog = new SpotsSummaryChartDialog(this.getDialogParent(), spot, summaries);
        dialog.setVisible(true);
    }

    private Window getDialogParent() {
        return SwingUtilities.getWindowAncestor(this);
    }

    public void setVisibleSpots(Set<String> visibleSpots) {
        this.spotPresenceTester = new SpotPresenceTester(visibleSpots);
        this.table.setRowFilter(new TestRowFilter(this.spotPresenceTester, 0));
    }

    public void setMascotIdentifications(SpotMascotIdentifications mascotIdentifications) {
        this.mascotIdentifications = Optional.ofNullable(mascotIdentifications);
        this.fireTableStructureChanged();
    }

    public void fireTableStructureChanged() {
        this.tableModel.fireTableStructureChanged();
    }

    public void setShowProteinIdentifications(boolean show) {
        this.showProteinIdentifications = show;
        this.updateUI();
    }

    public SpotSummary getSpotSummary(String spot, Condition c) {
        return this.tableModel.getSpotSummary(spot, c);
    }

    public void removeMascotIdentifications() {
        this.mascotIdentifications = Optional.empty();
    }

    private class ConditionsSummaryTableHeaderCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private TableCellRenderer defaultRenderer;

        public ConditionsSummaryTableHeaderCellRenderer(TableCellRenderer defaultRenderer) {
            this.defaultRenderer = defaultRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int columnModel = table.convertColumnIndexToModel(column);
            Optional<Condition> condition = ConditionsSummaryTable.this.tableModel.getConditionAt(columnModel);
            if (c instanceof JLabel) {
                c.setFont(c.getFont().deriveFont(1, 14.0f));
                if (condition.isPresent()) {
                    ((JLabel)c).setToolTipText(condition.get().getName());
                } else {
                    ((JLabel)c).setToolTipText("");
                }
            }
            return c;
        }
    }

    private class ConditionsSummaryTableCellRenderer
    extends DefaultTableRenderer {
        private static final long serialVersionUID = 1L;

        private ConditionsSummaryTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int columnModel = table.convertColumnIndexToModel(column);
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Optional<Condition> condition = ConditionsSummaryTable.this.tableModel.getConditionAt(columnModel);
            if (condition.isPresent()) {
                c.setBackground((Color)ConditionsSummaryTable.this.conditionsColors.get(condition.get()));
            }
            c.setFont(c.getFont().deriveFont(0, 14.0f));
            if (columnModel == 0) {
                String spot = value.toString();
                JLabel spotLabel = (JLabel)c;
                spotLabel.setText(SpotUtils.spotValue(spot, ConditionsSummaryTable.this.showProteinIdentifications, ConditionsSummaryTable.this.mascotIdentifications));
                spotLabel.setToolTipText(SpotUtils.spotTooltip(spot, ConditionsSummaryTable.this.mascotIdentifications));
                if (ConditionsSummaryTable.this.mascotIdentifications.isPresent()) {
                    if (!((SpotMascotIdentifications)ConditionsSummaryTable.this.mascotIdentifications.get()).get(spot).isEmpty()) {
                        if (!ConditionsSummaryTable.this.showProteinIdentifications) {
                            spotLabel.setFont(c.getFont().deriveFont(1));
                        }
                    } else {
                        spotLabel.setForeground(Color.RED);
                    }
                }
            }
            return c;
        }
    }
}

