/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.mascot;

import es.uvigo.ei.sing.s2p.core.entities.MascotEntry;
import es.uvigo.ei.sing.s2p.core.entities.SpotMascotIdentifications;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class MascotIdentificationsSummaryTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Map<Integer, String> TABLE_FIELDS = new HashMap<Integer, String>();
    private static Map<Integer, String> tableValues;
    private Set<String> spots;
    private SpotMascotIdentifications spotIdentifications;

    public MascotIdentificationsSummaryTableModel(Set<String> spots, SpotMascotIdentifications spotIdentifications) {
        this.spots = spots;
        this.spotIdentifications = spotIdentifications;
        this.initData();
    }

    private void initData() {
        tableValues.put(0, String.valueOf(this.spots.size()));
        tableValues.put(1, this.identifiedSpotsCount());
        tableValues.put(2, this.uniqueProteinsCount());
    }

    private String identifiedSpotsCount() {
        HashSet<String> unidentifiedSpots = new HashSet<String>(this.spots);
        unidentifiedSpots.removeAll(this.spotIdentifications.getSpots());
        return String.valueOf(this.spots.size() - unidentifiedSpots.size());
    }

    private String uniqueProteinsCount() {
        return String.valueOf(this.spotIdentifications.getSpots().stream().filter(spot -> this.spots.contains(spot)).map(spot -> this.spotIdentifications.get(spot)).flatMap(Collection::stream).map(MascotEntry::getTitle).distinct().count());
    }

    @Override
    public int getRowCount() {
        return 3;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? "" : "Value";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return TABLE_FIELDS.get(rowIndex);
        }
        return tableValues.get(rowIndex);
    }

    static {
        TABLE_FIELDS.put(0, "Analyzed spots");
        TABLE_FIELDS.put(1, "Identified spots");
        TABLE_FIELDS.put(2, "Different proteins identified");
        tableValues = new HashMap<Integer, String>();
    }
}

