/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.operations.quantification;

import es.uvigo.ei.sing.s2p.core.entities.quantification.ProteinQuantification;
import es.uvigo.ei.sing.s2p.core.entities.quantification.ProteinSummary;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationCondition;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationConditionSummary;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationConditionsSummary;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationDataset;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class QuantificationConditionsSummarizer {
    public static QuantificationConditionsSummary summary(QuantificationDataset data) {
        return QuantificationConditionsSummarizer.summary(data, data.getProteins());
    }

    public static QuantificationConditionsSummary summary(QuantificationDataset data, Set<String> proteins) {
        QuantificationConditionsSummary summary = new QuantificationConditionsSummary();
        data.getConditions().forEach(c -> summary.put(c, QuantificationConditionsSummarizer.conditionSummary(proteins, c)));
        return summary;
    }

    private static QuantificationConditionSummary conditionSummary(Set<String> proteins, QuantificationCondition c) {
        QuantificationConditionSummary summary = new QuantificationConditionSummary();
        proteins.forEach(protein -> summary.put(protein, QuantificationConditionsSummarizer.proteinSummary(protein, c)));
        return summary;
    }

    private static ProteinSummary proteinSummary(String protein, QuantificationCondition c) {
        LinkedList<Double> proteinValues = new LinkedList<Double>();
        LinkedList<Double> proteinMassValues = new LinkedList<Double>();
        LinkedList<Double> proteinNormalizedValues = new LinkedList<Double>();
        AtomicInteger replicatesCount = new AtomicInteger(0);
        c.getSamples().forEach(s -> {
            double proteinMass = s.getProteinMass();
            s.getReplicates().forEach(r -> {
                replicatesCount.set(replicatesCount.get() + 1);
                Optional<ProteinQuantification> pQ = r.findProtein(protein);
                if (pQ.isPresent()) {
                    double normalizedValue = pQ.get().getNormalizedValue();
                    double value = pQ.get().getValue();
                    double massValue = pQ.get().getNormalizedValue() * proteinMass;
                    if (!Double.isNaN(normalizedValue) && !Double.isNaN(value)) {
                        proteinNormalizedValues.add(normalizedValue);
                        proteinValues.add(value);
                        proteinMassValues.add(massValue);
                    }
                }
            });
        });
        return new ProteinSummary(replicatesCount.intValue(), proteinValues, proteinNormalizedValues, proteinMassValues);
    }
}

