/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.pipespecification.storage;

import es.uvigo.ei.aibench.core.operation.execution.Executable;
import es.uvigo.ei.aibench.core.operation.execution.IncompatibleConstraintsException;
import es.uvigo.ei.pipespecification.storage.CompositedPipeDefinition;
import es.uvigo.ei.pipespecification.storage.PipeDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class ArgsRenamerPipeDefinition
extends PipeDefinition {
    private final PipeDefinition pipeDef;
    private final Map<String, String> renamer;
    private final Map<String, String> inverseRenamer;

    ArgsRenamerPipeDefinition(Map<String, String> renamer, PipeDefinition pipeDef) {
        super(pipeDef.getIncomeTypes(), pipeDef.getOutcomeTypes());
        if (renamer == null) {
            throw new IllegalArgumentException("renamer cannot be null");
        }
        this.pipeDef = pipeDef;
        this.renamer = renamer;
        HashMap<String, String> inverse = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : renamer.entrySet()) {
            if (inverse.containsKey(entry.getValue())) {
                throw new IllegalArgumentException("You cannot rename two arguments to the same name");
            }
            inverse.put(entry.getValue(), entry.getKey());
        }
        this.inverseRenamer = Collections.unmodifiableMap(inverse);
    }

    @Override
    public PipeDefinition join(PipeDefinition rightPart) throws IncompatibleConstraintsException {
        return new CompositedPipeDefinition(this, rightPart);
    }

    @Override
    public int length() {
        return this.pipeDef.length();
    }

    @Override
    protected Executable instantiate_(Map<String, Object> args) {
        return this.pipeDef.instantiate_(ArgsRenamerPipeDefinition.rename(this.renamer, args));
    }

    private static <T> Map<String, T> rename(Map<String, String> renamer, Map<String, T> args) {
        HashMap<String, T> map = new HashMap<String, T>();
        Set<Map.Entry<String, T>> entrys = args.entrySet();
        for (Map.Entry<String, T> entry : entrys) {
            String newKeyName = renamer.get(entry.getKey());
            map.put(newKeyName == null ? entry.getKey() : newKeyName, entry.getValue());
        }
        return map;
    }

    @Override
    public Map<String, Class<?>> getArgumentsSpecification() {
        return ArgsRenamerPipeDefinition.rename(this.inverseRenamer, this.pipeDef.getArgumentsSpecification());
    }

    @Override
    public int totalLength() {
        return this.pipeDef.totalLength();
    }
}

