/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.hlfernandez.dialog;

import java.awt.Frame;
import java.awt.GridLayout;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class JProgressDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JFrame parent;
    private List<String> tasks;
    private JLabel taskLabel;
    private JProgressBar progressBar;
    private Iterator<String> tasksIterator;
    private int increment;
    private JPanel content;

    public JProgressDialog(JFrame parent, String title, List<String> tasks) {
        super((Frame)parent, title);
        this.parent = parent;
        this.tasks = tasks;
        this.tasksIterator = this.tasks.iterator();
        this.increment = 100 / tasks.size();
        this.initComponent();
    }

    private void initComponent() {
        this.content = new JPanel();
        this.content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.content.setLayout(new GridLayout(2, 2));
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setValue(0);
        this.taskLabel = new JLabel(this.tasksIterator.next());
        this.content.add(new JLabel("Current task:"));
        this.content.add(this.taskLabel);
        this.content.add(new JLabel("Total progress:"));
        this.content.add(this.progressBar);
        this.add(this.content);
        this.setResizable(false);
        this.setModal(false);
        this.centerDialogOnScreen();
    }

    public void finished(String message) {
        this.progressBar.setValue(100);
        this.taskLabel.setText(message);
    }

    public void nextTask() {
        if (this.tasksIterator.hasNext()) {
            this.progressBar.setValue(this.progressBar.getValue() + this.increment);
            this.taskLabel.setText(this.tasksIterator.next());
        } else {
            this.progressBar.setValue(100);
        }
    }

    protected void centerDialogOnScreen() {
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }
}

