/*
 * Decompiled with CFR 0.152.
 */
package org.platonos.pluginengine;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.platonos.pluginengine.Extension;
import org.platonos.pluginengine.Plugin;
import org.platonos.pluginengine.PluginEngine;
import org.platonos.pluginengine.PluginXmlParser;
import org.platonos.pluginengine.logging.LoggerLevel;
import org.xml.sax.SAXParseException;

public class ExtensionPoint {
    private final Plugin plugin;
    private final String name;
    private final String interfaceClassName;
    private final List<Extension> resolvedExtensions = new ArrayList<Extension>();
    private String schemaFilename;

    public ExtensionPoint(Plugin plugin, String name) {
        this(plugin, name, null);
    }

    public ExtensionPoint(Plugin plugin, String name, String interfaceClassName) {
        if (plugin == null) {
            throw new NullPointerException("Invalid argument: plugin");
        }
        if (plugin.getUID() == null) {
            throw new IllegalStateException("The plugin's UID must be set: " + plugin);
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid argument: name");
        }
        this.plugin = plugin;
        this.name = name;
        this.interfaceClassName = interfaceClassName;
    }

    public void setSchemaFilename(String schemaFilename) {
        if (schemaFilename == null) {
            throw new NullPointerException("Invalid argument: schemaFilename");
        }
        this.schemaFilename = schemaFilename;
    }

    public String getInterfaceClassName() {
        return this.interfaceClassName;
    }

    public Class<?> getInterfaceClass() {
        if (this.getInterfaceClassName() == null) {
            return null;
        }
        try {
            return Class.forName(this.getInterfaceClassName(), true, this.getPlugin().pluginClassloader);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public PluginEngine getPluginEngine() {
        return this.plugin.getPluginEngine();
    }

    public String getName() {
        return this.name;
    }

    public List<Extension> getExtensions() {
        return new ArrayList<Extension>(this.resolvedExtensions);
    }

    void addResolvedExtension(Extension extension) {
        if (this.resolvedExtensions.contains(extension)) {
            throw new IllegalArgumentException("Extension is already resolved to this ExtensionPoint.");
        }
        this.resolvedExtensions.add(extension);
    }

    void removeResolvedExtension(Extension extension) {
        if (!this.resolvedExtensions.remove(extension)) {
            throw new IllegalArgumentException("Extension is not resolved to this ExtensionPoint.");
        }
    }

    public boolean isExtensionCompatible(Extension extension) {
        if (extension == null) {
            throw new NullPointerException("Invalid argument: extension");
        }
        if (!this.isExtensionClassCompatible(extension.getExtensionClass())) {
            return false;
        }
        return this.isExtensionXmlCompatible(extension);
    }

    boolean isExtensionClassCompatible(Class<?> extensionClass) {
        Class<?> interfaceClass = this.getInterfaceClass();
        if (interfaceClass != null) {
            if (extensionClass == null) {
                return false;
            }
            if (!interfaceClass.isAssignableFrom(extensionClass)) {
                return false;
            }
        }
        return true;
    }

    boolean isExtensionXmlCompatible(Extension extension) {
        if (this.schemaFilename != null) {
            URL schemaURL = this.plugin.pluginClassloader.getResource(this.schemaFilename);
            if (schemaURL == null) {
                this.getPluginEngine().getLogger().log(LoggerLevel.SEVERE, "Unable to find schema for ExtensionPoint \"" + this + "\": " + this.schemaFilename, null);
                return false;
            }
            try {
                PluginXmlParser.validate(this.getPluginEngine(), schemaURL, extension.getExtensionXml());
            }
            catch (SAXParseException ex) {
                this.getPluginEngine().getLogger().log(LoggerLevel.SEVERE, "Extension XML failed schema validation for ExtensionPoint \"" + this + "\": " + extension, ex);
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.getName();
    }
}

