/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.math.statistical.test.linear;

import es.uvigo.ei.sing.math.statistical.test.linear.LogisticRegressionModelFitter;
import es.uvigo.ei.sing.math.statistical.test.linear.WekaLogisticRegressionModelFitter;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;

public class UnivariateLogisticRegressionDevianceTest {
    private boolean[] yVals;
    private double[] xVals;
    private int[] weights;
    private boolean[] weightedYVals;
    private double[] weightedXVals;
    private double yValsOdds;
    private LogisticRegressionModelFitter fitter;
    private double beta0;
    private double beta1;
    private double pValue;
    private int[] weightedWeights;

    public UnivariateLogisticRegressionDevianceTest(double[] xVals, boolean[] yVals, int[] weights) {
        this(xVals, yVals, weights, new WekaLogisticRegressionModelFitter());
    }

    public UnivariateLogisticRegressionDevianceTest(double[] xVals, boolean[] yVals, int[] weights, LogisticRegressionModelFitter fitter) {
        this.xVals = xVals;
        this.yVals = yVals;
        this.weights = weights;
        this.fitter = fitter;
        this.fitModel();
    }

    public double getPvalue() {
        return this.pValue;
    }

    private void fitModel() {
        this.doFit();
        this.computePValue();
    }

    private void computePValue() {
        double residualDeviance = 0.0;
        double nullDeviance = 0.0;
        int i = 0;
        while (i < this.weightedYVals.length) {
            double y = this.weightedYVals[i] ? 1.0 : 0.0;
            double x = this.weightedXVals[i];
            double prediction = 1.0 / (1.0 + Math.exp(-(this.beta0 + this.beta1 * x)));
            double nullPrediction = this.yValsOdds;
            if (y != prediction) {
                residualDeviance += this.computeDeviance(y, prediction);
            }
            if (y != nullPrediction) {
                nullDeviance += this.computeDeviance(y, nullPrediction);
            }
            ++i;
        }
        double deviance = nullDeviance - residualDeviance;
        ChiSquaredDistribution chisq = new ChiSquaredDistribution(1.0);
        this.pValue = 1.0 - chisq.cumulativeProbability(deviance);
    }

    private void doFit() {
        int numberOfSamples = this.sum(this.weights);
        this.weightedXVals = new double[numberOfSamples];
        this.weightedYVals = new boolean[numberOfSamples];
        this.weightedWeights = new int[numberOfSamples];
        double[][] transposedXVals = new double[numberOfSamples][1];
        int numberOfTrues = 0;
        int i = 0;
        int j = 0;
        while (i < this.xVals.length) {
            int k = 0;
            while (k < this.weights[i]) {
                this.weightedXVals[j] = this.xVals[i];
                this.weightedYVals[j] = this.yVals[i];
                if (this.weightedYVals[j]) {
                    ++numberOfTrues;
                }
                transposedXVals[j][0] = this.xVals[i];
                this.weightedWeights[j] = 1;
                ++j;
                ++k;
            }
            ++i;
        }
        double[] coefficients = this.fitter.fit(transposedXVals, this.weightedYVals, this.weightedWeights);
        this.yValsOdds = (double)numberOfTrues / (double)numberOfSamples;
        this.beta0 = coefficients[0];
        this.beta1 = coefficients[1];
    }

    private double computeDeviance(double y, double prediction) {
        return Math.pow((y == 1.0 ? y : -1.0) * Math.sqrt(-2.0 * (y * Math.log(prediction) + (1.0 - y) * Math.log(1.0 - prediction))), 2.0);
    }

    private int sum(int[] values) {
        int sum = 0;
        int i = 0;
        while (i < values.length) {
            sum += values[i];
            ++i;
        }
        return sum;
    }
}

