/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.io;

import es.uvigo.ei.sing.commons.csv.entities.CsvData;
import es.uvigo.ei.sing.commons.csv.entities.CsvEntry;
import es.uvigo.ei.sing.commons.csv.entities.CsvFormat;
import es.uvigo.ei.sing.commons.csv.io.CsvReader;
import es.uvigo.ei.sing.s2p.core.entities.SpotsData;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;

public class SpotsDataLoader {
    public static SpotsData load(File file, CsvFormat csvFormat) throws IOException {
        CsvData data = CsvReader.CsvReaderBuilder.newCsvReaderBuilder().withFormat(csvFormat).build().read(file);
        List<String> sampleLabels = SpotsDataLoader.parseSampleLabels((CsvEntry)data.remove(0));
        List<String> sampleNames = SpotsDataLoader.parseSampleNames((CsvEntry)data.remove(0));
        return new SpotsData(SpotsDataLoader.parseSpots((List<CsvEntry>)data), sampleNames, sampleLabels, SpotsDataLoader.parseData((List<CsvEntry>)data, sampleNames.size(), csvFormat));
    }

    private static List<String> parseSampleLabels(CsvEntry sampleLabels) {
        return sampleLabels.subList(1, sampleLabels.size());
    }

    private static List<String> parseSampleNames(CsvEntry sampleNames) {
        return sampleNames.subList(1, sampleNames.size());
    }

    private static List<String> parseSpots(List<CsvEntry> data) {
        LinkedList<String> spots = new LinkedList<String>();
        data.forEach(row -> spots.add((String)row.get(0)));
        return spots;
    }

    private static double[][] parseData(List<CsvEntry> data, int columns, CsvFormat csvFormat) {
        DecimalFormat decimalFormatter = csvFormat.getDecimalFormatter();
        double[][] matrixData = new double[data.size()][columns];
        data.forEach(row -> {
            int rowIndex = data.indexOf(row);
            for (int i = 1; i < row.size(); ++i) {
                String currentValue = ((String)row.get(i)).trim();
                if (currentValue.equals("")) {
                    matrixData[rowIndex][i - 1] = Double.NaN;
                    continue;
                }
                try {
                    matrixData[rowIndex][i - 1] = decimalFormatter.parse(currentValue).doubleValue();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return matrixData;
    }
}

