/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.inputgui;

import es.uvigo.ei.aibench.core.ParamSource;
import es.uvigo.ei.aibench.core.ParamSpec;
import es.uvigo.ei.aibench.core.operation.annotation.Port;
import es.uvigo.ei.aibench.workbench.ParamsReceiver;
import es.uvigo.ei.aibench.workbench.Workbench;
import es.uvigo.ei.aibench.workbench.inputgui.AbstractParamProvider;
import es.uvigo.ei.aibench.workbench.inputgui.Common;
import es.uvigo.ei.aibench.workbench.utilities.FileDrop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class FileParamProvider
extends AbstractParamProvider {
    private static final Logger LOG = Logger.getLogger(FileParamProvider.class);
    private final JTextField field = new JTextField();
    private final JButton findButton = new JButton(Common.ICON_FILE_OPEN);
    private final FileChooserConfiguration fcConfiguration;
    public static final String FILTERS_EXTRAS_PROPERTY = "filters";
    public static final String FILTERS_EXTRAS_ALLOWALL_FILTER = "allowAll";
    public static final String FILTERS_EXTRAS_SELECTION_MODE = "selectionMode";
    private static final String SELECTION_MODE_FILES_AND_DIRECTORIES = "filesAndDirectories";
    private static final String SELECTION_MODE_DIRECTORIES = "directories";
    private static final String SELECTION_MODE_FILES = "files";
    private JComponent component = null;

    public FileParamProvider(ParamsReceiver receiver, Port p, Class<?> clazz, Object operationObject) {
        super(receiver, p, clazz, operationObject);
        this.field.setEditable(false);
        this.fcConfiguration = new FileChooserConfiguration(p.extras());
        if (p.defaultValue().length() > 0) {
            this.field.setText(p.defaultValue());
        }
    }

    public static void configureFileChooser(Port p, JFileChooser fc) {
        FileChooserConfiguration.configure(p.extras(), fc);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.findButton) {
            this.showFileChooser();
        }
        super.actionPerformed(e);
    }

    private void showFileChooser() {
        int option;
        this.fcConfiguration.configureFileChooser(Common.SINGLE_FILE_CHOOSER);
        File selectedFile = this.getSelectedFile();
        if (selectedFile != null) {
            Common.SINGLE_FILE_CHOOSER.setSelectedFile(selectedFile);
        }
        if ((option = Common.SINGLE_FILE_CHOOSER.showDialog(Workbench.getInstance().getMainFrame(), "Select")) == 0) {
            this.setSelectedFile(Common.SINGLE_FILE_CHOOSER.getSelectedFile());
        }
    }

    private File getSelectedFile() {
        String text = this.field.getText().trim();
        return text.isEmpty() ? null : new File(text);
    }

    private void setSelectedFile(File file) {
        if (file == null) {
            this.field.setText("");
        } else {
            this.field.setText(file.getAbsolutePath());
        }
    }

    public JTextField getField() {
        return this.field;
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = new JPanel();
            this.component.setLayout(new BorderLayout());
            this.field.setPreferredSize(new Dimension(150, this.field.getPreferredSize().height));
            this.findButton.setToolTipText("Browse the local filesystem to select a file");
            this.component.add((Component)this.field, "Center");
            this.component.add((Component)this.findButton, "East");
            new FileDrop(this.field, new FileDrop.Listener(){

                @Override
                public void filesDropped(File[] files) {
                    if (files.length > 0) {
                        FileParamProvider.this.setSelectedFile(files[0]);
                        FileParamProvider.this.setChanged();
                        FileParamProvider.this.notifyObservers();
                    }
                }
            });
            this.field.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    FileParamProvider.this.showFileChooser();
                    FileParamProvider.this.setChanged();
                    FileParamProvider.this.notifyObservers();
                }
            });
            this.findButton.addActionListener(this);
        }
        return this.component;
    }

    @Override
    public ParamSpec getParamSpec() {
        File selectedFile = this.getSelectedFile();
        if (selectedFile == null) {
            return new ParamSpec(this.port.name(), this.clazz, null, ParamSource.CLIPBOARD);
        }
        return new ParamSpec(this.port.name(), this.clazz, (Object)selectedFile.getAbsolutePath(), ParamSource.STRING_CONSTRUCTOR);
    }

    @Override
    public boolean isValidValue() {
        return this.port.allowNull() || this.getSelectedFile() != null;
    }

    private static class FileChooserConfiguration {
        private final List<ExtensionFileFilter> filters = new ArrayList<ExtensionFileFilter>();
        private int selectionMode = 2;
        private boolean allowAll = true;

        public static void configure(String configuration, JFileChooser fc) {
            new FileChooserConfiguration(configuration).configureFileChooser(fc);
        }

        public FileChooserConfiguration(String configuration) {
            if (configuration != null && !configuration.trim().isEmpty()) {
                String[] props;
                for (String prop : props = configuration.split(",")) {
                    String[] propValue = prop.split("=");
                    if (propValue.length == 2) {
                        String property = propValue[0].trim();
                        String value = propValue[1].trim();
                        if (FileParamProvider.FILTERS_EXTRAS_PROPERTY.equalsIgnoreCase(property)) {
                            String[] filters;
                            this.allowAll = false;
                            for (String filter : filters = value.split(";")) {
                                String nameExtension;
                                String[] nameExpAndDesc = filter.split(":");
                                if (nameExpAndDesc.length == 2) {
                                    nameExtension = nameExpAndDesc[0].trim();
                                    String description = nameExpAndDesc[1].trim();
                                    this.filters.add(new ExtensionFileFilter(nameExtension, description));
                                    continue;
                                }
                                if (nameExpAndDesc.length != 1) continue;
                                nameExtension = nameExpAndDesc[0].trim();
                                if (FileParamProvider.FILTERS_EXTRAS_ALLOWALL_FILTER.equalsIgnoreCase(nameExtension)) {
                                    this.allowAll = true;
                                    continue;
                                }
                                LOG.warn((Object)("unable to parse a filter in extras: " + filter));
                            }
                            continue;
                        }
                        if (FileParamProvider.FILTERS_EXTRAS_SELECTION_MODE.equalsIgnoreCase(property)) {
                            if (FileParamProvider.SELECTION_MODE_FILES.equalsIgnoreCase(value)) {
                                this.selectionMode = 0;
                                continue;
                            }
                            if (FileParamProvider.SELECTION_MODE_DIRECTORIES.equalsIgnoreCase(value)) {
                                this.selectionMode = 1;
                                continue;
                            }
                            if (FileParamProvider.SELECTION_MODE_FILES_AND_DIRECTORIES.equalsIgnoreCase(value)) {
                                this.selectionMode = 2;
                                continue;
                            }
                            LOG.warn((Object)("unknown value for allowAll filter: " + value));
                            this.selectionMode = 2;
                            continue;
                        }
                        LOG.warn((Object)("unknown filter: " + property));
                        continue;
                    }
                    LOG.warn((Object)("unable to parse a property in extras: " + prop));
                }
            }
        }

        public void configureFileChooser(JFileChooser fc) {
            File selectedFile = fc.getSelectedFile();
            fc.setSelectedFile(null);
            fc.setAcceptAllFileFilterUsed(this.allowAll);
            fc.setFileSelectionMode(this.selectionMode);
            fc.resetChoosableFileFilters();
            for (ExtensionFileFilter filter : this.filters) {
                fc.addChoosableFileFilter(filter);
            }
            fc.setSelectedFile(selectedFile);
        }
    }

    private static class ExtensionFileFilter
    extends FileFilter {
        private final String nameregexp;
        private final String description;

        public ExtensionFileFilter(String nameregexp, String desc) {
            this.nameregexp = nameregexp;
            this.description = desc;
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().matches(this.nameregexp);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

