/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.pipespecification.storage;

import es.uvigo.ei.aibench.core.operation.OperationDefinition;
import es.uvigo.ei.aibench.core.operation.execution.Executable;
import es.uvigo.ei.aibench.core.operation.execution.IncompatibleConstraintsException;
import es.uvigo.ei.pipespecification.InvalidAnnotationsException;
import es.uvigo.ei.pipespecification.storage.CompositedPipeDefinition;
import es.uvigo.ei.pipespecification.storage.PipeDefinition;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.w3c.dom.Element;

class StandardPipeDefinition<T>
extends PipeDefinition {
    private static final String[] emptyArgsNames = new String[0];
    private static final Class<?>[] emptyTypes = new Class[0];
    private final Constructor<T> constructor;
    private final String[] argsNames;
    private final Class<?>[] classes;
    private Map<String, Class<?>> argumentsSpecification = null;
    private final OperationDefinition<T> metadata;
    private final ExecutorService executorService;

    StandardPipeDefinition(Class<T> klass, ExecutorService executor) throws InvalidAnnotationsException {
        this(klass, OperationDefinition.createOperationDefinition(klass), emptyArgsNames, emptyTypes, executor);
    }

    StandardPipeDefinition(Class<T> klass, String[] argsNames, Class<?>[] types, ExecutorService executor) throws InvalidAnnotationsException {
        this(klass, OperationDefinition.createOperationDefinition(klass), argsNames, types, executor);
    }

    StandardPipeDefinition(Class<T> klass, List<Element> ports, String[] argsNames, Class<?>[] types, ExecutorService executor) {
        this(klass, OperationDefinition.createOperationDefinition(klass, ports), argsNames, types, executor);
    }

    StandardPipeDefinition(Class<T> klass, OperationDefinition<T> metadata, String[] argsNames, Class<?>[] types, ExecutorService executor) {
        super(metadata.getIncomingArgumentTypes(), metadata.getOutcomingArgumentTypes());
        if (executor == null) {
            throw new NullPointerException("executor can't be null");
        }
        if (argsNames.length != types.length) {
            throw new IllegalArgumentException("argsNames and classes must have the same length");
        }
        try {
            Constructor<T> constructor = klass.getConstructor(types);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new IllegalArgumentException("The constructor" + constructor + "must be public");
            }
            this.argsNames = argsNames;
            this.classes = types;
            this.constructor = constructor;
            this.metadata = metadata;
            this.executorService = executor;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("There is no constructor for the types specified in the class " + klass);
        }
    }

    @Override
    protected Executable instantiate_(Map<String, Object> args) {
        int i;
        Object[] values = new Object[this.argsNames.length];
        for (i = 0; i < this.argsNames.length; ++i) {
            String paramName = this.argsNames[i];
            if (args.get(paramName) == null) {
                throw new IllegalArgumentException("There is no value for the parameter " + paramName);
            }
            values[i] = args.get(paramName);
        }
        for (i = 0; i < values.length; ++i) {
            if (this.classes[i].isAssignableFrom(values[i].getClass())) continue;
            throw new IllegalArgumentException("The argument " + this.argsNames[i] + " is not of the class required: " + this.classes[i]);
        }
        try {
            return this.metadata.makeExecutable(this.constructor.newInstance(this.constructor.getParameterTypes()), this.executorService, values);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected execption calling " + this.constructor.toString() + " with " + Arrays.asList(values));
        }
    }

    @Override
    public Map<String, Class<?>> getArgumentsSpecification() {
        if (this.argumentsSpecification == null) {
            this.argumentsSpecification = new HashMap();
            assert (this.argsNames.length == this.classes.length);
            for (int i = 0; i < this.argsNames.length; ++i) {
                this.argumentsSpecification.put(this.argsNames[i], this.classes[i]);
            }
            this.argumentsSpecification = Collections.unmodifiableMap(this.argumentsSpecification);
        }
        return this.argumentsSpecification;
    }

    @Override
    public PipeDefinition join(PipeDefinition rightPart) throws IncompatibleConstraintsException {
        return new CompositedPipeDefinition(this, rightPart);
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public int totalLength() {
        return 1;
    }
}

