/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.math.statistical;

import es.uvigo.ei.sing.math.statistical.UnsupportedMatrixException;
import es.uvigo.ei.sing.math.statistical.corrections.Correction;
import es.uvigo.ei.sing.math.statistical.tests.TestOfIndependence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public final class StatisticsTestsUtils {
    private static final int NI = 0;
    private static final int PI = 1;

    private StatisticsTestsUtils() {
    }

    private static void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private static <K> int[][][] createMultiTestMatrices(List<K> keyList, Map<K, Boolean[]> ... classMatrices) throws InterruptedException {
        StatisticsTestsUtils.checkInterrupted();
        if (classMatrices.length < 2) {
            throw new IllegalArgumentException("Two or more classMatrices must be provided");
        }
        HashSet<K> keySet = new HashSet<K>(keyList);
        Map<K, Boolean[]>[] mapArray = classMatrices;
        int n = classMatrices.length;
        int n2 = 0;
        while (n2 < n) {
            Map<K, Boolean[]> matrix = mapArray[n2];
            if (!keySet.equals(matrix.keySet())) {
                throw new IllegalArgumentException("classMatrices must have the same keys");
            }
            int length = -1;
            for (Map.Entry<K, Boolean[]> entries : matrix.entrySet()) {
                if (length == -1) {
                    length = entries.getValue().length;
                    if (length != 0) continue;
                    throw new IllegalArgumentException("Values array must have length > 0");
                }
                if (length == entries.getValue().length) continue;
                throw new IllegalArgumentException("Each classMatrix must have values arrays of the same size");
            }
            StatisticsTestsUtils.checkInterrupted();
            ++n2;
        }
        int[][][] matrices = new int[keyList.size()][][];
        int ci = 0;
        for (Object key : keyList) {
            int[][] classMatrix = new int[2][classMatrices.length];
            matrices[ci++] = classMatrix;
            int cmi = 0;
            Map<K, Boolean[]>[] mapArray2 = classMatrices;
            int n3 = classMatrices.length;
            int n4 = 0;
            while (n4 < n3) {
                Map<K, Boolean[]> matrix = mapArray2[n4];
                int[] negPos = StatisticsTestsUtils.binaryVectorToNegPos(matrix.get(key));
                classMatrix[0][cmi] = negPos[0];
                classMatrix[1][cmi++] = negPos[1];
                ++n4;
            }
            StatisticsTestsUtils.checkInterrupted();
        }
        return matrices;
    }

    public static <K> Map<K, Double> multiTest(TestOfIndependence toi, Map<K, Boolean[]> ... classMatrices) throws UnsupportedMatrixException, IllegalArgumentException, InterruptedException {
        StatisticsTestsUtils.checkInterrupted();
        ArrayList<K> keyList = new ArrayList<K>(classMatrices[0].keySet());
        int[][][] matrices = StatisticsTestsUtils.createMultiTestMatrices(keyList, classMatrices);
        StatisticsTestsUtils.checkInterrupted();
        double[] pValues = toi.multiTest(matrices);
        HashMap pValuesMap = new HashMap();
        int ki = 0;
        for (Object key : keyList) {
            pValuesMap.put(key, pValues[ki++]);
        }
        StatisticsTestsUtils.checkInterrupted();
        return pValuesMap;
    }

    public static <K> Map<K, TestOfIndependence.Probabilities> multiTest(TestOfIndependence toi, Correction correction, Map<K, Boolean[]> ... classMatrices) throws UnsupportedMatrixException, IllegalArgumentException, InterruptedException {
        StatisticsTestsUtils.checkInterrupted();
        ArrayList<K> keyList = new ArrayList<K>(classMatrices[0].keySet());
        int[][][] matrices = StatisticsTestsUtils.createMultiTestMatrices(keyList, classMatrices);
        StatisticsTestsUtils.checkInterrupted();
        TestOfIndependence.Probabilities[] pValues = toi.correctedMultiTest(correction, matrices);
        HashMap pValuesMap = new HashMap();
        int ki = 0;
        for (Object key : keyList) {
            pValuesMap.put(key, pValues[ki++]);
        }
        StatisticsTestsUtils.checkInterrupted();
        return pValuesMap;
    }

    public static <K> Map<K, Double> correct(Correction correction, Map<K, Double> pValues) throws InterruptedException {
        StatisticsTestsUtils.checkInterrupted();
        ArrayList<K> keyList = new ArrayList<K>(pValues.keySet());
        double[] pValuesArray = new double[keyList.size()];
        int i = 0;
        for (Object key : keyList) {
            pValuesArray[i++] = pValues.get(key);
        }
        StatisticsTestsUtils.checkInterrupted();
        double[] qValuesArray = correction.correct(pValuesArray);
        HashMap qValues = new HashMap();
        i = 0;
        for (Object key : keyList) {
            qValues.put(key, qValuesArray[i++]);
        }
        StatisticsTestsUtils.checkInterrupted();
        return qValues;
    }

    public static int[] binaryVectorToNegPos(Boolean[] vector) {
        int[] negPos = new int[2];
        Boolean[] booleanArray = vector;
        int n = vector.length;
        int n2 = 0;
        while (n2 < n) {
            Boolean value = booleanArray[n2];
            if (value != null) {
                int n3 = value != false ? 1 : 0;
                negPos[n3] = negPos[n3] + 1;
            }
            ++n2;
        }
        return negPos;
    }

    public static int[][] binaryVectorToMatrix(boolean[] vector, int[] samplesByClass) throws IllegalArgumentException {
        int numSamples = IntStream.of(samplesByClass).sum();
        if (vector.length != numSamples) {
            throw new IllegalArgumentException("The number of samples in vector and samplesByClass must be the same");
        }
        int[][] matrix = new int[2][samplesByClass.length];
        int vi = 0;
        int ci = 0;
        while (ci < samplesByClass.length) {
            int numClassSamples = samplesByClass[ci];
            int numSample = 0;
            while (numSample < numClassSamples) {
                boolean value;
                int[] nArray = matrix[(value = vector[vi++]) ? 1 : 0];
                int n = ci;
                nArray[n] = nArray[n] + 1;
                ++numSample;
            }
            ++ci;
        }
        return matrix;
    }
}

